/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FT_Span
extends Struct<FT_Span> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int LEN;
    public static final int COVERAGE;

    protected FT_Span(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_Span create(long address, @Nullable ByteBuffer container) {
        return new FT_Span(address, container);
    }

    public FT_Span(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_Span.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public short x() {
        return FT_Span.nx(this.address());
    }

    @NativeType(value="unsigned short")
    public short len() {
        return FT_Span.nlen(this.address());
    }

    @NativeType(value="unsigned char")
    public byte coverage() {
        return FT_Span.ncoverage(this.address());
    }

    public static FT_Span create(long address) {
        return new FT_Span(address, null);
    }

    @Nullable
    public static FT_Span createSafe(long address) {
        return address == 0L ? null : new FT_Span(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static short nx(long struct) {
        return UNSAFE.getShort(null, struct + (long)X);
    }

    public static short nlen(long struct) {
        return UNSAFE.getShort(null, struct + (long)LEN);
    }

    public static byte ncoverage(long struct) {
        return UNSAFE.getByte(null, struct + (long)COVERAGE);
    }

    static {
        Struct.Layout layout = FT_Span.__struct((Struct.Member[])new Struct.Member[]{FT_Span.__member((int)2), FT_Span.__member((int)2), FT_Span.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        LEN = layout.offsetof(1);
        COVERAGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<FT_Span, Buffer> {
        private static final FT_Span ELEMENT_FACTORY = FT_Span.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected FT_Span getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public short x() {
            return FT_Span.nx(this.address());
        }

        @NativeType(value="unsigned short")
        public short len() {
            return FT_Span.nlen(this.address());
        }

        @NativeType(value="unsigned char")
        public byte coverage() {
            return FT_Span.ncoverage(this.address());
        }
    }
}

