/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge;

import com.gravitlauncher.socketbridge.EmptyResponse;
import com.gravitlauncher.socketbridge.ErrorResponse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Registry {
    private final Map<String, Class<?>> map = new ConcurrentHashMap();
    private final Map<Class<?>, String> reverseMap = new ConcurrentHashMap();

    public static Registry makeDefaultRegistry() {
        Registry registry = new Registry();
        registry.register("error", ErrorResponse.class);
        registry.register("empty", EmptyResponse.class);
        return registry;
    }

    public void register(String name, Class<?> clazz) {
        this.map.put(name, clazz);
        this.reverseMap.put(clazz, name);
    }

    public void unregister(String name) {
        Class<?> clazz = this.map.remove(name);
        if (clazz != null) {
            this.reverseMap.remove(clazz);
        }
    }

    public <T> Class<T> get(String name) {
        return this.map.get(name);
    }

    public String get(Class<?> clazz) {
        return this.reverseMap.get(clazz);
    }
}

