/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.io.IOException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.core.managers.GsonManager;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);
    public static final AtomicBoolean LAUNCHED = new AtomicBoolean(false);
    public static final String RUNTIME_DIR = "runtime";
    public static final String CONFIG_FILE = "config.bin";
    private static final AtomicReference<LauncherConfig> CONFIG = new AtomicReference();
    private static final Pattern UUID_PATTERN = Pattern.compile("-", 16);
    public static ClientProfile profile;
    public static GsonManager gsonManager;

    public static LauncherConfig getConfig() {
        LauncherConfig config = CONFIG.get();
        if (config == null) {
            try (HInput input = new HInput(IOHelper.newInput(IOHelper.getResourceURL(CONFIG_FILE)));){
                config = new LauncherConfig(input);
            }
            catch (IOException | InvalidKeySpecException e) {
                throw new SecurityException(e);
            }
            CONFIG.set(config);
        }
        return config;
    }

    public static void setConfig(LauncherConfig cfg) {
        CONFIG.set(cfg);
    }

    public static URL getResourceURL(String name) throws IOException {
        LauncherConfig config = Launcher.getConfig();
        byte[] validDigest = config.runtime.get(name);
        if (validDigest == null) {
            throw new NoSuchFileException(name);
        }
        URL url = IOHelper.getResourceURL("runtime/" + name);
        return url;
    }

    public static URL getResourceURL(String name, String prefix) throws IOException {
        LauncherConfig config = Launcher.getConfig();
        byte[] validDigest = config.runtime.get(name);
        if (validDigest == null) {
            throw new NoSuchFileException(name);
        }
        URL url = IOHelper.getResourceURL(prefix + "/" + name);
        return url;
    }

    public static String toHash(UUID uuid) {
        return UUID_PATTERN.matcher(uuid.toString()).replaceAll("");
    }

    public static void applyLauncherEnv(LauncherConfig.LauncherEnvironment env) {
        switch (env) {
            case DEV: {
                LogHelper.setDevEnabled(true);
                LogHelper.setStacktraceEnabled(true);
                LogHelper.setDebugEnabled(true);
                break;
            }
            case DEBUG: {
                LogHelper.setDebugEnabled(true);
                LogHelper.setStacktraceEnabled(true);
                break;
            }
            case STD: {
                LogHelper.setStacktraceEnabled(true);
                break;
            }
            case PROD: {
                LogHelper.setStacktraceEnabled(false);
                LogHelper.setDebugEnabled(false);
                LogHelper.setDevEnabled(false);
            }
        }
    }

    public static String makeSpecialGuardDirName(JVMHelper.ARCH arch, JVMHelper.OS os) {
        return String.format("%s-%s", arch.name, os.name);
    }
}

