/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.core.BuildInParams;
import pro.gravit.launcher.core.LauncherInjectionConstructor;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.core.serialize.stream.StreamObject;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    private static final Logger logger = LoggerFactory.getLogger(LauncherConfig.class);
    private static final List<byte[]> secureConfigCertificates;
    private static final List<Class<?>> modulesClasses;
    private static final MethodType VOID_TYPE;
    public final String projectName;
    public final int clientPort;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey ecdsaPublicKey;
    public final RSAPublicKey rsaPublicKey;
    public final Map<String, byte[]> runtime;
    public final String secureCheckHash;
    public final String secureCheckSalt;
    public final String passwordEncryptKey;
    public final String runtimeEncryptKey;
    public final String address;
    public String secretKeyClient;
    public String unlockSecret;
    public LauncherEnvironment environment;
    public long buildNumber;
    public Map<String, String> customJavaDownload;
    public boolean forceUseCustomJava;

    @LauncherInjectionConstructor
    public LauncherConfig(HInput input) throws IOException, InvalidKeySpecException {
        this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey(input.readByteArray(2048));
        this.rsaPublicKey = SecurityHelper.toPublicRSAKey(input.readByteArray(2048));
        this.secureCheckHash = "UVNwqw73xk3GCrzDRxk0rH/dTTbIhqCVZQ2myx0zLgI=";
        this.secureCheckSalt = "d2facb542eb85cf2f5824831afcaabc4";
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.projectName = "Erdmar";
        this.clientPort = 32367;
        this.secretKeyClient = "04ac9fa5a5ac9a8cffbce54a505282a4";
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        this.address = "ws://81.19.136.89:9274/api";
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int count = input.readLength(0);
        HashMap localResources = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            String name = input.readString(255);
            VerifyHelper.putIfAbsent(localResources, name, input.readByteArray(2048), String.format("Duplicate runtime resource: '%s'", name));
        }
        this.runtime = Collections.unmodifiableMap(localResources);
        this.unlockSecret = "b4fed05a02cb9d22446c5e863ce01cc2";
        this.customJavaDownload = new HashMap<String, String>();
        this.forceUseCustomJava = false;
    }

    public LauncherConfig(String address, ECPublicKey ecdsaPublicKey, RSAPublicKey rsaPublicKey, Map<String, byte[]> runtime, String projectName) {
        this.address = address;
        this.ecdsaPublicKey = ecdsaPublicKey;
        this.rsaPublicKey = rsaPublicKey;
        this.runtime = Map.copyOf(runtime);
        this.projectName = projectName;
        this.clientPort = 32148;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.trustManager = null;
    }

    public LauncherConfig(String address, Map<String, byte[]> runtime, String projectName, LauncherEnvironment env, LauncherTrustManager trustManager) {
        this.address = address;
        this.runtime = Map.copyOf(runtime);
        this.projectName = projectName;
        this.clientPort = 32148;
        this.trustManager = trustManager;
        this.rsaPublicKey = null;
        this.ecdsaPublicKey = null;
        this.environment = env;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
    }

    public void apply() {
        Version version = Version.getVersion();
        BuildInParams.setVersion(new Version(version.major, version.minor, version.patch, (int)this.buildNumber));
        BuildInParams.setProjectName(this.projectName);
    }

    public static void initModules(LauncherModulesManager modulesManager) {
        if (JVMHelper.JVM_VERSION >= 17) {
            modulesClasses.addAll(ModernModulesClass.modulesClasses);
        }
        for (Class<?> clazz : modulesClasses) {
            try {
                modulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
        modulesClasses.clear();
    }

    @Override
    public void write(HOutput output) throws IOException {
        output.writeByteArray(this.ecdsaPublicKey.getEncoded(), 2048);
        output.writeByteArray(this.rsaPublicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> entrySet = this.runtime.entrySet();
        output.writeLength(entrySet.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            output.writeString(entry.getKey(), 255);
            output.writeByteArray(entry.getValue(), 2048);
        }
    }

    static {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIB+TCCAaCgAwIBAgIJAJambfoLCtx1MAoGCCqGSM49BAMCMHExCzAJBgNVBAYTAlJVMQ8wDQYDVQQIEwZNb3Njb3cxDzANBgNVBAcTBk1vc2NvdzEXMBUGA1UEChMORXJkbWFyIFByb2plY3QxDTALBgNVBAsTBEdhbWUxGDAWBgNVBAMTD0VyZG1hciBMYXVuY2hlcjAeFw0yNjAyMjQxMTM0NTRaFw0zNjAyMjIxMTM0NTRaMHExCzAJBgNVBAYTAlJVMQ8wDQYDVQQIEwZNb3Njb3cxDzANBgNVBAcTBk1vc2NvdzEXMBUGA1UEChMORXJkbWFyIFByb2plY3QxDTALBgNVBAsTBEdhbWUxGDAWBgNVBAMTD0VyZG1hciBMYXVuY2hlcjBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABBfmoDiUC+YhAcu1a2ZJ4HTtFKqFns0Em9JvnR0Thm+wSefJ7J4w/9yVI96GDAWbQubIya6+87e5G4rflrk6QUqjITAfMB0GA1UdDgQWBBTLmymjqV2IZerCuhIr6M4KLbzCpzAKBggqhkjOPQQDAgNHADBEAiALDmoHHQhjqZtbYPSrOiv6Fjtj8SEgAPPGI18G4buuJwIgLIP5ybbY7AvSK5iuPWmLyK+h/zOyh6xzXHYeKKl6QqM="));
        secureConfigCertificates = arrayList;
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(JavaRuntimeModule.class);
        modulesClasses = arrayList2;
        VOID_TYPE = MethodType.methodType(Void.TYPE);
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }

    private static class ModernModulesClass {
        private static final List<Class<?>> modulesClasses = new ArrayList(0);

        private ModernModulesClass() {
        }
    }
}

