/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.config.JsonConfigurableLoggerHolder;
import pro.gravit.utils.helper.IOHelper;

public interface JsonConfigurableInterface<T> {
    default public void saveConfig() throws IOException {
        this.saveConfig(this.getPath());
    }

    default public void loadConfig() throws IOException {
        this.loadConfig(this.getPath());
    }

    default public void saveConfig(Gson gson, Path configPath) throws IOException {
        try (BufferedWriter writer = IOHelper.newWriter(configPath);){
            gson.toJson(this.getConfig(), this.getType(), writer);
        }
    }

    default public String toJsonString(Gson gson) {
        return gson.toJson(this.getConfig(), this.getType());
    }

    default public String toJsonString() {
        return this.toJsonString(Launcher.gsonManager.configGson);
    }

    default public void loadConfig(Gson gson, Path configPath) throws IOException {
        if (this.generateConfigIfNotExists(configPath)) {
            return;
        }
        try (BufferedReader reader = IOHelper.newReader(configPath);){
            Object value = gson.fromJson((Reader)reader, this.getType());
            if (value == null) {
                JsonConfigurableLoggerHolder.logger.warn("Config {} is null", (Object)configPath);
                this.resetConfig(configPath);
                return;
            }
            this.setConfig(value);
        }
        catch (Exception e) {
            JsonConfigurableLoggerHolder.logger.error("", e);
            this.resetConfig(configPath);
        }
    }

    default public void saveConfig(Path configPath) throws IOException {
        this.saveConfig(Launcher.gsonManager.configGson, configPath);
    }

    default public void loadConfig(Path configPath) throws IOException {
        this.loadConfig(Launcher.gsonManager.configGson, configPath);
    }

    default public void resetConfig() throws IOException {
        this.setConfig(this.getDefaultConfig());
        this.saveConfig();
    }

    default public void resetConfig(Path newPath) throws IOException {
        this.setConfig(this.getDefaultConfig());
        this.saveConfig(newPath);
    }

    default public boolean generateConfigIfNotExists(Path path) throws IOException {
        if (IOHelper.isFile(path)) {
            return false;
        }
        this.resetConfig(path);
        return true;
    }

    default public boolean generateConfigIfNotExists() throws IOException {
        if (IOHelper.isFile(this.getPath())) {
            return false;
        }
        this.resetConfig();
        return true;
    }

    public T getConfig();

    public void setConfig(T var1);

    public T getDefaultConfig();

    public Path getPath();

    public Type getType();
}

