/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.modules.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.config.SimpleConfigurable;
import pro.gravit.launcher.base.modules.ModulesConfigManager;
import pro.gravit.utils.helper.IOHelper;

public class SimpleModulesConfigManager
implements ModulesConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleModulesConfigManager.class);
    public final Path configDir;

    public SimpleModulesConfigManager(Path configDir) {
        this.configDir = configDir;
    }

    @Override
    public Path getModuleConfig(String moduleName) {
        return this.getModuleConfig(moduleName, "Config");
    }

    @Override
    public Path getModuleConfig(String moduleName, String configName) {
        return this.getModuleConfigDir(moduleName).resolve(configName.concat(".json"));
    }

    @Override
    public Path getModuleConfigDir(String moduleName) {
        if (!IOHelper.isDir(this.configDir)) {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("", e);
            }
        }
        return this.configDir.resolve(moduleName);
    }

    @Override
    public <T> SimpleConfigurable<T> getConfigurable(Class<T> tClass, Path configPath) {
        return new SimpleConfigurable<T>(tClass, configPath);
    }
}

