/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.core.api.model.User;
import pro.gravit.utils.helper.IOHelper;

public final class PlayerProfile
implements User {
    public final UUID uuid;
    public final String username;
    public final Map<String, Texture> assets;
    public final Map<String, String> properties;

    @Deprecated
    public PlayerProfile(UUID uuid, String username, Texture skin, Texture cloak) {
        this(uuid, username, skin, cloak, new HashMap<String, String>());
    }

    @Deprecated
    public PlayerProfile(UUID uuid, String username, Texture skin, Texture cloak, Map<String, String> properties) {
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.username = username;
        this.assets = new HashMap<String, Texture>();
        if (skin != null) {
            this.assets.put("SKIN", skin);
        }
        if (cloak != null) {
            this.assets.put("CAPE", cloak);
        }
        this.properties = properties;
    }

    public PlayerProfile(UUID uuid, String username, Map<String, Texture> assets, Map<String, String> properties) {
        this.uuid = uuid;
        this.username = username;
        this.assets = assets;
        this.properties = properties;
    }

    public PlayerProfile(User user) {
        this.uuid = user.getUUID();
        this.username = user.getUsername();
        this.assets = new HashMap<String, pro.gravit.launcher.core.api.model.Texture>(user.getAssets());
        this.properties = user.getProperties();
    }

    public static PlayerProfile newOfflineProfile(String username) {
        return new PlayerProfile(PlayerProfile.offlineUUID(username), username, new HashMap<String, Texture>(), new HashMap<String, String>());
    }

    public static UUID offlineUUID(String username) {
        return UUID.nameUUIDFromBytes(IOHelper.encodeASCII("OfflinePlayer:" + username));
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Map<String, pro.gravit.launcher.core.api.model.Texture> getAssets() {
        return this.assets;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

