/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.core.serialize.stream.StreamObject;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class Texture
extends StreamObject
implements pro.gravit.launcher.core.api.model.Texture {
    private static final SecurityHelper.DigestAlgorithm DIGEST_ALGO = SecurityHelper.DigestAlgorithm.SHA256;
    public final String url;
    public final byte[] digest;
    public final Map<String, String> metadata;

    public Texture(String url, boolean cloak, Map<String, String> metadata) throws IOException {
        byte[] texture;
        InputStream input;
        this.url = IOHelper.verifyURL(url);
        try {
            input = IOHelper.newInput(new URI(url).toURL());
            try {
                texture = IOHelper.read(input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        input = new ByteArrayInputStream(texture);
        try {
            IOHelper.readTexture(input, cloak);
        }
        finally {
            ((ByteArrayInputStream)input).close();
        }
        this.digest = SecurityHelper.digest(DIGEST_ALGO, texture);
        this.metadata = metadata;
    }

    public Texture(String url, Path local, boolean cloak, Map<String, String> metadata) throws IOException {
        byte[] texture;
        this.url = IOHelper.verifyURL(url);
        try (InputStream input = IOHelper.newInput(local);){
            texture = IOHelper.read(input);
        }
        input = new ByteArrayInputStream(texture);
        try {
            IOHelper.readTexture(input, cloak);
        }
        finally {
            ((ByteArrayInputStream)input).close();
        }
        this.digest = SecurityHelper.digest(DIGEST_ALGO, texture);
        this.metadata = metadata;
    }

    @Deprecated
    public Texture(String url, byte[] digest) {
        this.url = IOHelper.verifyURL(url);
        this.digest = digest == null ? new byte[]{} : digest;
        this.metadata = null;
    }

    public Texture(String url, byte[] digest, Map<String, String> metadata) {
        this.url = url;
        this.digest = digest == null ? new byte[]{} : digest;
        this.metadata = metadata;
    }

    @Override
    public void write(HOutput output) throws IOException {
        output.writeASCII(this.url, 2048);
        output.writeByteArray(this.digest, -Texture.DIGEST_ALGO.bytes);
    }

    public String toString() {
        return "Texture{url='" + this.url + "', digest=" + Arrays.toString(this.digest) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getHash() {
        return SecurityHelper.toHex(this.digest);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

