/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles.optional.actions;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.core.hasher.HashedDir;

public class OptionalActionFile
extends OptionalAction {
    private static final Logger logger = LoggerFactory.getLogger(OptionalActionFile.class);
    public Map<String, String> files;

    public OptionalActionFile() {
    }

    public OptionalActionFile(Map<String, String> files) {
        this.files = files;
    }

    public void injectToHashedDir(HashedDir dir) {
        if (this.files == null) {
            return;
        }
        this.files.forEach((k, v) -> {
            HashedDir.FindRecursiveResult firstPath = dir.findRecursive((String)k);
            if (v != null && !v.isEmpty()) {
                logger.info("Debug findRecursive: name {}, parent: ", firstPath.name, firstPath.parent == null ? "null" : "not null", firstPath.entry == null ? "null" : "not null");
                HashedDir.FindRecursiveResult secondPath = dir.findRecursive((String)v);
                logger.info("Debug findRecursive: name {}, parent: ", secondPath.name, secondPath.parent == null ? "null" : "not null", secondPath.entry == null ? "null" : "not null");
                firstPath.parent.moveTo(firstPath.name, secondPath.parent, secondPath.name);
            }
        });
    }

    public void disableInHashedDir(HashedDir dir) {
        if (this.files == null) {
            return;
        }
        this.files.forEach((k, v) -> {
            HashedDir.FindRecursiveResult firstPath = dir.findRecursive((String)k);
            firstPath.parent.remove(firstPath.name);
        });
    }
}

