/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.websockets;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;

public class OfflineRequestService
implements RequestService {
    private static final Logger logger = LoggerFactory.getLogger(OfflineRequestService.class);
    private final HashSet<RequestService.EventHandler> eventHandlers = new HashSet();
    private final Map<Class<?>, RequestProcessor<?, ?>> processors = new ConcurrentHashMap();

    @Override
    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) {
        RequestProcessor<?, ?> processor = this.processors.get(request.getClass());
        CompletableFuture future = new CompletableFuture();
        if (processor == null) {
            future.completeExceptionally(new RequestException(String.format("Offline mode not support '%s'", request.getType())));
            return future;
        }
        logger.info("Request {}: {}", (Object)request.getType(), (Object)Launcher.gsonManager.gson.toJson(request));
        try {
            Object event = processor.process(request);
            logger.info("Response {}: {}", (Object)event.getType(), (Object)Launcher.gsonManager.gson.toJson(event));
            future.complete(event);
        }
        catch (Throwable e) {
            if (e instanceof RequestException) {
                future.completeExceptionally(e);
            }
            future.completeExceptionally(new RequestException(e));
        }
        return future;
    }

    @Override
    public void connect() {
    }

    @Override
    public void registerEventHandler(RequestService.EventHandler handler) {
        this.eventHandlers.add(handler);
    }

    @Override
    public void unregisterEventHandler(RequestService.EventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public <T extends WebSocketEvent, V extends WebSocketRequest> void registerRequestProcessor(Class<V> requestClazz, RequestProcessor<T, V> function) {
        this.processors.put(requestClazz, function);
    }

    public <T extends WebSocketEvent> void unregisterRequestProcessor(Class<Request<T>> requestClazz) {
        this.processors.remove(requestClazz);
    }

    public static interface RequestProcessor<T extends WebSocketEvent, V extends WebSocketRequest> {
        public T process(V var1) throws RequestException;
    }
}

