/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.vfs.directory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import pro.gravit.launcher.base.vfs.VfsDirectory;
import pro.gravit.launcher.base.vfs.VfsEntry;
import pro.gravit.launcher.base.vfs.VfsException;
import pro.gravit.launcher.base.vfs.file.FileVfsFile;

public class FileVfsDirectory
extends VfsDirectory {
    private final Path path;

    public FileVfsDirectory(Path path) {
        this.path = path;
    }

    @Override
    public VfsEntry find(String name) {
        Path target = this.path.resolve(name);
        if (Files.exists(target, new LinkOption[0])) {
            if (Files.isDirectory(target, new LinkOption[0])) {
                return new FileVfsDirectory(target);
            }
            return new FileVfsFile(target);
        }
        return null;
    }

    @Override
    public VfsEntry resolve(Path path) {
        if (path == null) {
            return this;
        }
        Path target = this.path.resolve(path);
        if (Files.exists(target, new LinkOption[0])) {
            if (Files.isDirectory(target, new LinkOption[0])) {
                return new FileVfsDirectory(target);
            }
            return new FileVfsFile(target);
        }
        return null;
    }

    @Override
    public Stream<String> getFiles() {
        try {
            return Files.list(this.path).map(Path::getFileName).map(Path::toString);
        }
        catch (IOException e) {
            throw new VfsException(e);
        }
    }
}

