/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.vfs.directory;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import pro.gravit.launcher.base.vfs.VfsDirectory;
import pro.gravit.launcher.base.vfs.VfsEntry;

public class SimpleVfsDirectory
extends VfsDirectory {
    private final Map<String, VfsEntry> map = new HashMap<String, VfsEntry>();

    @Override
    public VfsEntry find(String name) {
        return this.map.get(name);
    }

    @Override
    public VfsEntry resolve(Path path) {
        if (path == null) {
            return this;
        }
        VfsDirectory current = this;
        for (int i = 0; i < path.getNameCount(); ++i) {
            VfsDirectory newDir;
            String s = path.getName(i).toString();
            VfsEntry entity = ((VfsDirectory)current).find(s);
            if (entity instanceof VfsDirectory) {
                newDir = (VfsDirectory)entity;
                if (!(entity instanceof SimpleVfsDirectory)) {
                    if (i + 1 >= path.getNameCount()) {
                        return newDir;
                    }
                    Path newPath = path.subpath(i + 1, path.getNameCount());
                    return newDir.resolve(newPath);
                }
            } else {
                return entity;
            }
            current = newDir;
        }
        return current;
    }

    public VfsEntry remove(String name) {
        return this.map.remove(name);
    }

    public void put(String name, VfsEntry entry) {
        this.map.put(name, entry);
    }

    @Override
    public Stream<String> getFiles() {
        return this.map.keySet().stream();
    }
}

