/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.vfs.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import pro.gravit.launcher.base.vfs.VfsFile;

public class CachedVfsFile
extends VfsFile {
    private final VfsFile delegate;
    private volatile SoftReference<byte[]> cache;

    public CachedVfsFile(VfsFile delegate) {
        this.delegate = delegate;
    }

    private synchronized InputStream tryCache() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (InputStream input = this.delegate.getInputStream();){
                input.transferTo(output);
            }
            byte[] bytes = output.toByteArray();
            this.cache = new SoftReference<byte[]>(bytes);
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException | OutOfMemoryError throwable) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() {
        byte[] cachedBytes;
        byte[] byArray = cachedBytes = this.cache == null ? null : this.cache.get();
        if (cachedBytes != null) {
            return new ByteArrayInputStream(cachedBytes);
        }
        InputStream cached = this.tryCache();
        if (cached != null) {
            return cached;
        }
        return this.delegate.getInputStream();
    }
}

