/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.vfs.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import pro.gravit.launcher.base.vfs.VfsException;
import pro.gravit.launcher.base.vfs.VfsFile;

public class FileVfsFile
extends VfsFile {
    private final File file;

    public FileVfsFile(File file) {
        this.file = file;
    }

    public FileVfsFile(Path path) {
        this.file = path.toFile();
    }

    @Override
    public URLConnection openConnection(URL url) {
        try {
            return this.file.toURI().toURL().openConnection();
        }
        catch (IOException e) {
            throw new VfsException(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new VfsException(e);
        }
    }
}

