/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.CipherInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.api.AuthService;
import pro.gravit.launcher.base.api.ClientService;
import pro.gravit.launcher.base.api.KeyService;
import pro.gravit.launcher.base.modules.events.PreConfigPhase;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionClassPath;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestCoreFeatureAPIImpl;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.client.BasicLauncherEventHandler;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherMethods;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.events.ClientProcessClassLoaderEvent;
import pro.gravit.launcher.client.events.ClientProcessInitPhase;
import pro.gravit.launcher.client.events.ClientProcessLaunchEvent;
import pro.gravit.launcher.client.events.ClientProcessPreInvokeMainClassEvent;
import pro.gravit.launcher.client.events.ClientProcessReadyEvent;
import pro.gravit.launcher.client.utils.DirWatcher;
import pro.gravit.launcher.core.api.LauncherAPI;
import pro.gravit.launcher.core.api.LauncherAPIHolder;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.api.features.UserFeatureAPI;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.hasher.HashedEntry;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ClientLauncherEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(ClientLauncherEntryPoint.class);
    public static ClientModuleManager modulesManager;
    public static ClientParams clientParams;
    private static Launch launch;
    private static ClassLoaderControl classLoaderControl;

    private static ClientParams readParams(SocketAddress address) throws IOException {
        try (Socket socket = IOHelper.newSocket();){
            ClientParams clientParams;
            socket.connect(address);
            try (HInput input = new HInput(new CipherInputStream(socket.getInputStream(), SecurityHelper.newAESDecryptCipher(SecurityHelper.fromHex(Launcher.getConfig().secretKeyClient))));){
                byte[] serialized = input.readByteArray(0);
                ClientParams params = Launcher.gsonManager.gson.fromJson(IOHelper.decode(serialized), ClientParams.class);
                params.clientHDir = new HashedDir(input);
                params.assetHDir = new HashedDir(input);
                boolean isNeedReadJavaDir = input.readBoolean();
                if (isNeedReadJavaDir) {
                    params.javaHDir = new HashedDir(input);
                }
                clientParams = params;
            }
            return clientParams;
        }
    }

    public static void main(String[] args) {
        JVMHelper.verifySystemProperties(ClientLauncherEntryPoint.class, true);
        EnvHelper.checkDangerousParams();
        JVMHelper.checkStackTrace(ClientLauncherEntryPoint.class);
        LogHelper.printVersion("Client Launcher");
        ClientLauncherMethods.checkClass(ClientLauncherEntryPoint.class);
        try {
            ClientLauncherEntryPoint.realMain(args);
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    private static void realMain(String[] args) throws Throwable {
        ClientProfile profile;
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules(modulesManager);
        modulesManager.initModules(null);
        ClientLauncherMethods.initGson(modulesManager);
        modulesManager.invokeEvent(new PreConfigPhase());
        logger.debug("Reading ClientLauncher params");
        ClientParams params = ClientLauncherEntryPoint.readParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        ClientLauncherMethods.verifyNoAgent();
        if (params.timestamp > System.currentTimeMillis() || params.timestamp + 30000L < System.currentTimeMillis()) {
            logger.error("Timestamp failed: current {} | params {} | diff {}", System.currentTimeMillis(), params.timestamp, System.currentTimeMillis() - params.timestamp);
            ClientLauncherMethods.exitLauncher(-662);
            return;
        }
        Launcher.profile = profile = params.profile;
        AuthService.profile = profile;
        clientParams = params;
        if (params.oauth != null) {
            logger.info("Using OAuth");
            if (params.oauthExpiredTime != 0L) {
                Request.setOAuth(params.authId, params.oauth, params.oauthExpiredTime);
            } else {
                Request.setOAuth(params.authId, params.oauth);
            }
            if (params.extendedTokens != null) {
                Request.addAllExtendedToken(params.extendedTokens);
            }
        } else if (params.session != null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        modulesManager.invokeEvent(new ClientProcessInitPhase(params));
        Path clientDir = Paths.get(params.clientDir, new String[0]);
        Path assetDir = Paths.get(params.assetDir, new String[0]);
        logger.debug("Verifying ClientLauncher sign and classpath");
        LauncherConfig config = Launcher.getConfig();
        config.apply();
        if (params.offlineMode) {
            service = ClientLauncherMethods.initOffline(modulesManager, params);
            Request.setRequestService(service);
        } else {
            service = StdWebSocketService.initWebSockets(config.address).get();
            Request.setRequestService(service);
            logger.debug("Restore sessions");
            Request.restore(false, false, true);
            service.registerEventHandler(new BasicLauncherEventHandler());
            ((StdWebSocketService)service).reconnectCallback = () -> {
                logger.debug("WebSocket connect closed. Try reconnect");
                try {
                    Request.reconnect();
                }
                catch (Exception e) {
                    logger.error("", e);
                    throw new RequestException("Connection failed", e);
                }
            };
        }
        LauncherAPIHolder.setCoreAPI(new RequestCoreFeatureAPIImpl(Request.getRequestService()));
        LauncherAPIHolder.setCreateApiFactory(authId -> {
            RequestFeatureAPIImpl impl = new RequestFeatureAPIImpl(Request.getRequestService(), (String)authId);
            return new LauncherAPI(Map.of(AuthFeatureAPI.class, impl, UserFeatureAPI.class, impl, ProfileFeatureAPI.class, impl, TextureUploadFeatureAPI.class, impl, HardwareVerificationFeatureAPI.class, impl));
        });
        LauncherAPIHolder.changeAuthId(params.authId);
        logger.debug("Natives dir {}", (Object)params.nativesDir);
        ClientProfile.ClassLoaderConfig classLoaderConfig = profile.getClassLoaderConfig();
        LaunchOptions options = new LaunchOptions();
        options.enableHacks = profile.hasFlag(ClientProfile.CompatibilityFlags.ENABLE_HACKS);
        options.moduleConf = profile.getModuleConf();
        ClientService.nativePath = params.nativesDir;
        if (profile.getLoadNatives() != null) {
            for (String string : profile.getLoadNatives()) {
                System.load(Paths.get(params.nativesDir, new String[0]).resolve(ClientService.findLibrary(string)).toAbsolutePath().toString());
            }
        }
        HashSet<Path> ignoredPath = new HashSet<Path>();
        if (options.moduleConf != null && options.moduleConf.modulePath != null) {
            List<Path> list = ClientLauncherEntryPoint.resolveClassPathStream(ignoredPath, clientDir, options.moduleConf.modulePath).toList();
        }
        List list = ClientLauncherEntryPoint.resolveClassPath(ignoredPath, clientDir, params.actions, params.profile).collect(Collectors.toCollection(ArrayList::new));
        for (Path e : list) {
            logger.info("Classpath entry {}", (Object)e);
        }
        List<URL> classpathURLs = list.stream().map(IOHelper::toURL).toList();
        if (classLoaderConfig == ClientProfile.ClassLoaderConfig.LAUNCHER || classLoaderConfig == ClientProfile.ClassLoaderConfig.MODULE) {
            launch = JVMHelper.JVM_VERSION <= 11 ? new LegacyLaunch() : new ModuleLaunch();
            classLoaderControl = launch.init(list, params.nativesDir, options);
            System.setProperty("java.class.path", list.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(launch, classLoaderControl, profile));
            ClientService.baseURLs = classLoaderControl.getURLs();
        } else if (classLoaderConfig == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            launch = new BasicLaunch();
            System.setProperty("java.class.path", list.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            classLoaderControl = launch.init(list, params.nativesDir, options);
            ClientService.baseURLs = classpathURLs.toArray(new URL[0]);
        } else {
            throw new UnsupportedOperationException(String.format("Unknown classLoaderConfig %s", new Object[]{classLoaderConfig}));
        }
        if (profile.hasFlag(ClientProfile.CompatibilityFlags.CLASS_CONTROL_API)) {
            ClientService.classLoaderControl = classLoaderControl;
        }
        if (params.lwjglGlfwWayland && profile.hasFlag(ClientProfile.CompatibilityFlags.WAYLAND_USE_CUSTOM_GLFW)) {
            String glfwName = ClientService.findLibrary("glfw_wayland");
            System.setProperty("org.lwjgl.glfw.libname", glfwName);
        }
        AuthService.projectName = Launcher.getConfig().projectName;
        AuthService.username = params.playerProfile.username;
        AuthService.uuid = params.playerProfile.uuid;
        KeyService.serverRsaPublicKey = Launcher.getConfig().rsaPublicKey;
        KeyService.serverEcPublicKey = Launcher.getConfig().ecdsaPublicKey;
        modulesManager.invokeEvent(new ClientProcessReadyEvent(params));
        logger.debug("Starting JVM and client WatchService");
        FileNameMatcher assetMatcher = profile.getAssetUpdateMatcher();
        FileNameMatcher clientMatcher = profile.getClientUpdateMatcher();
        Path javaDir = Paths.get(System.getProperty("java.home"), new String[0]);
        try (DirWatcher assetWatcher = new DirWatcher(assetDir, params.assetHDir, assetMatcher, true);
             DirWatcher clientWatcher = new DirWatcher(clientDir, params.clientHDir, clientMatcher, true);
             DirWatcher javaWatcher = params.javaHDir == null ? null : new DirWatcher(javaDir, params.javaHDir, null, true);){
            CommonHelper.newThread("Asset Directory Watcher", true, assetWatcher).start();
            CommonHelper.newThread("Client Directory Watcher", true, clientWatcher).start();
            if (javaWatcher != null) {
                CommonHelper.newThread("Java Directory Watcher", true, javaWatcher).start();
            }
            ClientLauncherEntryPoint.verifyHDir(assetDir, params.assetHDir, assetMatcher, false, false);
            ClientLauncherEntryPoint.verifyHDir(clientDir, params.clientHDir, clientMatcher, false, true);
            if (javaWatcher != null) {
                ClientLauncherEntryPoint.verifyHDir(javaDir, params.javaHDir, null, false, true);
            }
            modulesManager.invokeEvent(new ClientProcessLaunchEvent(params));
            ClientLauncherEntryPoint.launch(profile, params);
        }
    }

    public static void verifyHDir(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest, boolean checkExtra) throws IOException {
        HashedDir currentHDir = new HashedDir(dir, matcher, true, digest);
        HashedDir.Diff diff = hdir.diff(currentHDir, matcher);
        AtomicReference<String> latestPath = new AtomicReference<String>("unknown");
        if (!diff.mismatch.isEmpty() || checkExtra && !diff.extra.isEmpty()) {
            diff.extra.walk(File.separator, (e, k, v) -> {
                if (v.getType().equals(HashedEntry.Type.FILE)) {
                    logger.error("Extra file {}", (Object)e);
                    latestPath.set(e);
                } else {
                    logger.error("Extra {}", (Object)e);
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            diff.mismatch.walk(File.separator, (e, k, v) -> {
                if (v.getType().equals(HashedEntry.Type.FILE)) {
                    logger.error("Mismatch file {}", (Object)e);
                    latestPath.set(e);
                } else {
                    logger.error("Mismatch {}", (Object)e);
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            throw new SecurityException(String.format("Forbidden modification: '%s' file '%s'", IOHelper.getFileName(dir), latestPath.get()));
        }
    }

    private static LinkedList<Path> resolveClassPathList(Set<Path> ignorePaths, Path clientDir, List<String> classPath) throws IOException {
        return ClientLauncherEntryPoint.resolveClassPathStream(ignorePaths, clientDir, classPath).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Path> resolveClassPathStream(Set<Path> ignorePaths, Path clientDir, List<String> classPath) throws IOException {
        Stream.Builder<Path> builder = Stream.builder();
        for (String classPathEntry : classPath) {
            Path path = clientDir.resolve(IOHelper.toPath(classPathEntry.replace("/", IOHelper.PLATFORM_SEPARATOR)));
            if (IOHelper.isDir(path)) {
                ArrayList<Path> jars = new ArrayList<Path>(32);
                IOHelper.walk(path, new ClassPathFileVisitor(jars), false);
                Collections.sort(jars);
                for (Path e : jars) {
                    if (ignorePaths.contains(e)) continue;
                    builder.accept(e);
                    ignorePaths.add(e);
                }
                continue;
            }
            if (ignorePaths.contains(path)) continue;
            builder.accept(path);
            ignorePaths.add(path);
        }
        return builder.build();
    }

    public static Stream<Path> resolveClassPath(Set<Path> ignorePaths, Path clientDir, Set<OptionalAction> actions, ClientProfile profile) throws IOException {
        Stream<Path> result = ClientLauncherEntryPoint.resolveClassPathStream(ignorePaths, clientDir, profile.getClassPath());
        if (actions != null) {
            for (OptionalAction a : actions) {
                if (!(a instanceof OptionalActionClassPath)) continue;
                result = Stream.concat(result, ClientLauncherEntryPoint.resolveClassPathStream(ignorePaths, clientDir, ((OptionalActionClassPath)a).args));
            }
        }
        return result;
    }

    private static void launch(ClientProfile profile, ClientParams params) throws Throwable {
        LinkedList<String> args = new LinkedList<String>();
        if (profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
            params.addClientArgs(args);
        } else {
            params.addClientLegacyArgs(args);
            System.setProperty("minecraft.applet.TargetDirectory", params.clientDir);
        }
        args.addAll(profile.getClientArgs());
        for (OptionalAction action : params.actions) {
            if (!(action instanceof OptionalActionClientArgs)) continue;
            args.addAll(((OptionalActionClientArgs)action).args);
        }
        ArrayList<String> copy = new ArrayList<String>(args);
        int l = copy.size();
        for (int i = 0; i < l; ++i) {
            String s = (String)copy.get(i);
            if (i + 1 >= l || !"--accessToken".equals(s) && !"--session".equals(s)) continue;
            copy.set(i + 1, "censored");
        }
        logger.debug("Args: " + String.valueOf(copy));
        modulesManager.invokeEvent(new ClientProcessPreInvokeMainClassEvent(params, profile, args));
        try {
            List<String> compatClasses = profile.getCompatClasses();
            for (String e : compatClasses) {
                Class<?> clazz = classLoaderControl.getClass(e);
                MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                runMethod.invoke(classLoaderControl);
            }
            Launcher.LAUNCHED.set(true);
            JVMHelper.fullGC();
            launch.launch(params.profile.getMainClass(), params.profile.getMainModule(), args);
            logger.debug("Main exit successful");
        }
        catch (Throwable e) {
            logger.error("", e);
            throw e;
        }
        finally {
            ClientLauncherMethods.exitLauncher(0);
        }
    }

    private static final class ClassPathFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> result;

        private ClassPathFileVisitor(List<Path> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (IOHelper.hasExtension(file, "jar") || IOHelper.hasExtension(file, "zip")) {
                this.result.add(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

