/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.api;

import java.util.function.Consumer;
import pro.gravit.launcher.base.events.NotificationEvent;

public class DialogService {
    private static DialogServiceImplementation dialogImpl;
    private static DialogServiceNotificationImplementation notificationImpl;

    private DialogService() {
        throw new UnsupportedOperationException();
    }

    public static void setDialogImpl(DialogServiceImplementation impl) {
        dialogImpl = impl;
    }

    public static void setNotificationImpl(DialogServiceNotificationImplementation impl) {
        notificationImpl = impl;
    }

    public static boolean isDialogsAvailable() {
        return dialogImpl != null;
    }

    public static boolean isNotificationsAvailable() {
        return notificationImpl != null;
    }

    private static void checkIfAvailable() {
        if (!DialogService.isDialogsAvailable()) {
            throw new UnsupportedOperationException("DialogService dialogs implementation not available");
        }
    }

    public static void createNotification(NotificationEvent.NotificationType type, String head, String message) {
        if (!DialogService.isNotificationsAvailable()) {
            throw new UnsupportedOperationException("DialogService notifications implementation not available");
        }
        notificationImpl.createNotification(type, head, message);
    }

    public static void showDialog(String header, String text, Runnable onApplyCallback, Runnable onCloseCallback) {
        DialogService.checkIfAvailable();
        dialogImpl.showDialog(header, text, onApplyCallback, onCloseCallback);
    }

    public static void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback) {
        DialogService.checkIfAvailable();
        dialogImpl.showApplyDialog(header, text, onApplyCallback, onDenyCallback);
    }

    public static void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, Runnable onCloseCallback) {
        DialogService.checkIfAvailable();
        dialogImpl.showApplyDialog(header, text, onApplyCallback, onDenyCallback, onCloseCallback);
    }

    public static void showTextDialog(String header, Consumer<String> onApplyCallback, Runnable onCloseCallback) {
        DialogService.checkIfAvailable();
        dialogImpl.showTextDialog(header, onApplyCallback, onCloseCallback);
    }

    public static interface DialogServiceImplementation {
        public void showDialog(String var1, String var2, Runnable var3, Runnable var4);

        public void showApplyDialog(String var1, String var2, Runnable var3, Runnable var4);

        public void showApplyDialog(String var1, String var2, Runnable var3, Runnable var4, Runnable var5);

        public void showTextDialog(String var1, Consumer<String> var2, Runnable var3);
    }

    public static interface DialogServiceNotificationImplementation {
        public void createNotification(NotificationEvent.NotificationType var1, String var2, String var3);
    }
}

