/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.api.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import pro.gravit.launcher.core.api.features.FeatureAPI;
import pro.gravit.launcher.core.api.model.User;

public interface UserFeatureAPI
extends FeatureAPI {
    public CompletableFuture<User> getUserByUsername(String var1);

    public CompletableFuture<User> getUserByUUID(UUID var1);

    public CompletableFuture<Void> joinServer(String var1, String var2, String var3);

    public CompletableFuture<Void> joinServer(UUID var1, String var2, String var3);

    public CompletableFuture<CheckServerResponse> checkServer(String var1, String var2, boolean var3);

    default public CompletableFuture<List<User>> getUsersByUsernames(List<String> usernames) {
        ArrayList<CompletableFuture<User>> list = new ArrayList<CompletableFuture<User>>();
        for (String username : usernames) {
            list.add(this.getUserByUsername(username));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new)).thenApply(x -> {
            ArrayList<User> r = new ArrayList<User>();
            for (CompletableFuture e : list) {
                try {
                    r.add((User)e.get());
                }
                catch (InterruptedException | ExecutionException ex) {
                    r.add(null);
                }
            }
            return r;
        });
    }

    public record CheckServerResponse(User user, String hardwareId, String sessionId, Map<String, String> sessionProperties) {
    }
}

