/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.hasher;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.core.hasher.HashedEntry;
import pro.gravit.launcher.core.hasher.HashedFile;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.core.serialize.stream.EnumSerializer;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class HashedDir
extends HashedEntry {
    @LauncherNetworkAPI
    private final Map<String, HashedEntry> map = new HashMap<String, HashedEntry>(32);

    public HashedDir() {
    }

    public HashedDir(HInput input) throws IOException {
        int entriesCount = input.readLength(0);
        for (int i = 0; i < entriesCount; ++i) {
            String name = IOHelper.verifyFileName(input.readString(255));
            HashedEntry.Type type = HashedEntry.Type.read(input);
            HashedEntry entry = switch (type) {
                default -> throw new MatchException(null, null);
                case HashedEntry.Type.FILE -> new HashedFile(input);
                case HashedEntry.Type.DIR -> new HashedDir(input);
            };
            VerifyHelper.putIfAbsent(this.map, name, entry, String.format("Duplicate dir entry: '%s'", name));
        }
    }

    public HashedDir(Path dir, FileNameMatcher matcher, boolean allowSymlinks, boolean digest) throws IOException {
        IOHelper.walk(dir, new HashFileVisitor(dir, matcher, allowSymlinks, digest), true);
    }

    public Diff diff(HashedDir other, FileNameMatcher matcher) {
        HashedDir mismatch = this.sideDiff(other, matcher, new LinkedList<String>(), true);
        HashedDir extra = other.sideDiff(this, matcher, new LinkedList<String>(), false);
        return new Diff(mismatch, extra);
    }

    public Diff compare(HashedDir other, FileNameMatcher matcher) {
        HashedDir mismatch = this.sideDiff(other, matcher, new LinkedList<String>(), true);
        HashedDir extra = other.sideDiff(this, matcher, new LinkedList<String>(), false);
        return new Diff(mismatch, extra);
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public void moveTo(String elementName, HashedDir target, String targetElementName) {
        HashedEntry entry = this.map.remove(elementName);
        target.map.put(targetElementName, entry);
    }

    public FindRecursiveResult findRecursive(String path) {
        HashedEntry e;
        StringTokenizer t = new StringTokenizer(path, "/");
        HashedDir current = this;
        HashedEntry entry = null;
        String name = null;
        while (t.hasMoreTokens() && ((e = current.map.get(name = t.nextToken())) != null || t.hasMoreTokens())) {
            if (e == null) {
                throw new RuntimeException(String.format("Directory %s not found", name));
            }
            if (e.getType() == HashedEntry.Type.DIR) {
                if (!t.hasMoreTokens()) {
                    entry = e;
                    break;
                }
                current = (HashedDir)e;
                continue;
            }
            entry = e;
            break;
        }
        return new FindRecursiveResult(current, entry, name);
    }

    public FindRecursiveResult tryFindRecursive(String path) {
        HashedEntry e;
        StringTokenizer t = new StringTokenizer(path, "/");
        HashedDir current = this;
        HashedEntry entry = null;
        String name = null;
        while (t.hasMoreTokens() && ((e = current.map.get(name = t.nextToken())) != null || t.hasMoreTokens())) {
            if (e == null) {
                return new FindRecursiveResult(current, entry, name);
            }
            if (e.getType() == HashedEntry.Type.DIR) {
                if (!t.hasMoreTokens()) {
                    entry = e;
                    break;
                }
                current = (HashedDir)e;
                continue;
            }
            entry = e;
            break;
        }
        return new FindRecursiveResult(current, entry, name);
    }

    public HashedEntry getEntry(String name) {
        return this.map.get(name);
    }

    @Override
    public HashedEntry.Type getType() {
        return HashedEntry.Type.DIR;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<String, HashedEntry> map() {
        return Collections.unmodifiableMap(this.map);
    }

    public HashedEntry resolve(Iterable<String> path) {
        HashedEntry current = this;
        for (String pathEntry : path) {
            if (current instanceof HashedDir) {
                current = current.map.get(pathEntry);
                continue;
            }
            return null;
        }
        return current;
    }

    private HashedDir sideDiff(HashedDir other, FileNameMatcher matcher, Deque<String> path, boolean mismatchList) {
        HashedDir diff = new HashedDir();
        for (Map.Entry<String, HashedEntry> mapEntry : this.map.entrySet()) {
            String name = mapEntry.getKey();
            HashedEntry entry = mapEntry.getValue();
            path.add(name);
            boolean shouldUpdate = matcher == null || matcher.shouldUpdate(path);
            HashedEntry.Type type = entry.getType();
            HashedEntry otherEntry = other.map.get(name);
            if (otherEntry == null || otherEntry.getType() != type) {
                if (shouldUpdate || mismatchList && otherEntry == null) {
                    diff.map.put(name, entry);
                    if (!mismatchList) {
                        entry.flag = true;
                    }
                }
                path.removeLast();
                continue;
            }
            switch (type) {
                case FILE: {
                    HashedFile file = (HashedFile)entry;
                    HashedFile otherFile = (HashedFile)otherEntry;
                    if (!mismatchList || !shouldUpdate || file.isSame(otherFile)) break;
                    diff.map.put(name, entry);
                    break;
                }
                case DIR: {
                    HashedDir mismatch;
                    HashedDir dir = (HashedDir)entry;
                    HashedDir otherDir = (HashedDir)otherEntry;
                    if (!mismatchList && !shouldUpdate || (mismatch = dir.sideDiff(otherDir, matcher, path, mismatchList)).isEmpty()) break;
                    diff.map.put(name, mismatch);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            path.removeLast();
        }
        return diff;
    }

    public HashedDir sideCompare(HashedDir other, FileNameMatcher matcher, Deque<String> path, boolean mismatchList) {
        HashedDir diff = new HashedDir();
        for (Map.Entry<String, HashedEntry> mapEntry : this.map.entrySet()) {
            String name = mapEntry.getKey();
            HashedEntry entry = mapEntry.getValue();
            path.add(name);
            boolean shouldUpdate = matcher == null || matcher.shouldUpdate(path);
            HashedEntry.Type type = entry.getType();
            HashedEntry otherEntry = other.map.get(name);
            if (otherEntry == null || otherEntry.getType() != type) {
                if (shouldUpdate || mismatchList && otherEntry == null) {
                    diff.map.put(name, entry);
                    if (!mismatchList) {
                        entry.flag = true;
                    }
                }
                path.removeLast();
                continue;
            }
            switch (type) {
                case FILE: {
                    HashedFile file = (HashedFile)entry;
                    HashedFile otherFile = (HashedFile)otherEntry;
                    if (!mismatchList || !shouldUpdate || !file.isSame(otherFile)) break;
                    diff.map.put(name, entry);
                    break;
                }
                case DIR: {
                    HashedDir mismatch;
                    HashedDir dir = (HashedDir)entry;
                    HashedDir otherDir = (HashedDir)otherEntry;
                    if (!mismatchList && !shouldUpdate || (mismatch = dir.sideCompare(otherDir, matcher, path, mismatchList)).isEmpty()) break;
                    diff.map.put(name, mismatch);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported hashed entry type: " + type.name()));
                }
            }
            path.removeLast();
        }
        return diff;
    }

    @Override
    public long size() {
        return this.map.values().stream().mapToLong(HashedEntry::size).sum();
    }

    @Override
    public void write(HOutput output) throws IOException {
        Set<Map.Entry<String, HashedEntry>> entries = this.map.entrySet();
        output.writeLength(entries.size(), 0);
        for (Map.Entry<String, HashedEntry> mapEntry : entries) {
            output.writeString(mapEntry.getKey(), 255);
            HashedEntry entry = mapEntry.getValue();
            EnumSerializer.write(output, entry.getType());
            entry.write(output);
        }
    }

    public void walk(CharSequence separator, WalkCallback callback) throws IOException {
        String append = "";
        this.walk(append, separator, callback, true);
    }

    private WalkAction walk(String append, CharSequence separator, WalkCallback callback, boolean noSeparator) throws IOException {
        for (Map.Entry<String, HashedEntry> entry : this.map.entrySet()) {
            HashedEntry e = entry.getValue();
            if (e.getType() == HashedEntry.Type.FILE) {
                WalkAction a;
                if (!(noSeparator ? (a = callback.walked(append + entry.getKey(), entry.getKey(), e)) == WalkAction.STOP : (a = callback.walked(append + String.valueOf(separator) + entry.getKey(), entry.getKey(), e)) == WalkAction.STOP)) continue;
                return a;
            }
            String newAppend = noSeparator ? append + entry.getKey() : append + String.valueOf(separator) + entry.getKey();
            WalkAction a = callback.walked(newAppend, entry.getKey(), e);
            if (a == WalkAction.STOP) {
                return a;
            }
            a = ((HashedDir)e).walk(newAppend, separator, callback, false);
            if (a != WalkAction.STOP) continue;
            return a;
        }
        return WalkAction.CONTINUE;
    }

    private final class HashFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dir;
        private final FileNameMatcher matcher;
        private final boolean allowSymlinks;
        private final boolean digest;
        private final Deque<String> path = new LinkedList<String>();
        private final Deque<HashedDir> stack = new LinkedList<HashedDir>();
        private HashedDir current = HashedDir.this;

        private HashFileVisitor(Path dir, FileNameMatcher matcher, boolean allowSymlinks, boolean digest) {
            this.dir = dir;
            this.matcher = matcher;
            this.allowSymlinks = allowSymlinks;
            this.digest = digest;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            FileVisitResult result = super.postVisitDirectory(dir, exc);
            if (this.dir.equals(dir)) {
                return result;
            }
            HashedDir parent = this.stack.removeLast();
            parent.map.put(this.path.removeLast(), this.current);
            this.current = parent;
            return result;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.preVisitDirectory(dir, attrs);
            if (this.dir.equals(dir)) {
                return result;
            }
            if (!this.allowSymlinks && attrs.isSymbolicLink()) {
                throw new SecurityException("Symlinks are not allowed");
            }
            this.stack.add(this.current);
            this.current = new HashedDir();
            this.path.add(IOHelper.getFileName(dir));
            return result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!this.allowSymlinks && attrs.isSymbolicLink()) {
                throw new SecurityException("Symlinks are not allowed");
            }
            this.path.add(IOHelper.getFileName(file));
            boolean doDigest = this.digest && (this.matcher == null || this.matcher.shouldUpdate(this.path));
            this.current.map.put(this.path.removeLast(), new HashedFile(file, attrs.size(), doDigest));
            return super.visitFile(file, attrs);
        }
    }

    public static final class Diff {
        public final HashedDir mismatch;
        public final HashedDir extra;

        private Diff(HashedDir mismatch, HashedDir extra) {
            this.mismatch = mismatch;
            this.extra = extra;
        }

        public boolean isSame() {
            return this.mismatch.isEmpty() && this.extra.isEmpty();
        }
    }

    public static class FindRecursiveResult {
        public final HashedDir parent;
        public final HashedEntry entry;
        public final String name;

        public FindRecursiveResult(HashedDir parent, HashedEntry entry, String name) {
            this.parent = parent;
            this.entry = entry;
            this.name = name;
        }

        public boolean isFound() {
            return this.entry != null;
        }
    }

    @FunctionalInterface
    public static interface WalkCallback {
        public WalkAction walked(String var1, String var2, HashedEntry var3);
    }

    public static enum WalkAction {
        STOP,
        CONTINUE;

    }
}

