/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui;

import java.lang.reflect.Method;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.stage.Stage;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.modules.LauncherInitContext;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.LauncherModuleInfo;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientUnlockConsoleEvent;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.StdJavaRuntimeProvider;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.runtime.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.runtime.gui.RuntimeProvider;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;

public class JavaRuntimeModule
extends LauncherModule {
    private static final Logger logger = LoggerFactory.getLogger(JavaRuntimeModule.class);
    public static final String RUNTIME_NAME = "stdruntime";
    static LauncherEngine engine;
    private RuntimeProvider provider;
    public static AtomicBoolean SHUTDOWN_STARTED;

    public JavaRuntimeModule() {
        super(new LauncherModuleInfo("StdJavaRuntime", new Version(5, 0, 0, 6, Version.Type.BETA), 0, new String[0], new String[]{"runtime"}));
    }

    private static void noJavaFxAlert() {
        String message = "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 JavaFX \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b. \u0423 \u0432\u0430\u0441 %s(x%d) \u041e\u0421 %s(x%d). Java %s. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 JavaFX\n\u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443 \u0441\u0430\u043c\u043e\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u043d\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430\n".formatted(JVMHelper.RUNTIME_MXBEAN.getVmName(), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name, JVMHelper.OS_BITS, JVMHelper.RUNTIME_MXBEAN.getSpecVersion());
        JOptionPane.showMessageDialog(null, message, "GravitLauncher", 0);
    }

    private static void noInitMethodAlert() {
        String message = "JavaFX \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u0440\u0430\u043d\u043e \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0441 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u043c \u044d\u0442\u043e\u0433\u043e \u043e\u043a\u043d\u0430\n\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:\n\u041f\u0440\u0438 \u0441\u0431\u043e\u0440\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u043b\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 JavaFX. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 JavaFX \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u043b\u0430\u0443\u043d\u0447\u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0441\u0431\u043e\u0440\u043a\u0443 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430\n";
        JOptionPane.showMessageDialog(null, message, "GravitLauncher", 0);
    }

    public static void noLocaleAlert(String file) {
        String message = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b \u044f\u0437\u044b\u043a\u0430 '%s' \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 GUI. \u0414\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c \u0447\u0442\u043e \u0432\u0441\u0435 \u0444\u0430\u0439\u043b\u044b \u0434\u0438\u0437\u0430\u0439\u043d\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432 \u043f\u0430\u043f\u043a\u0435 runtime \u043f\u0440\u0438 \u0441\u0431\u043e\u0440\u043a\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430\n".formatted(file);
        JOptionPane.showMessageDialog(null, message, "GravitLauncher", 0);
    }

    public static void errorHandleAlert(Throwable e) {
        String message = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u0435\u0440\u044c\u0435\u0437\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430.\n\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439:\n\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0441 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u043c \u044d\u0442\u043e\u0433\u043e \u043e\u043a\u043d\u0430\nJava %d (x%d) \u041e\u0448\u0438\u0431\u043a\u0430 %s\n\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: %s\n\u0411\u043e\u043b\u0435\u0435 \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u0437 \u043b\u043e\u0433\u0430\n".formatted(JVMHelper.JVM_VERSION, JVMHelper.JVM_BITS, e.getClass().getName(), e.getMessage() == null ? "null" : e.getMessage());
        JOptionPane.showMessageDialog(null, message, "GravitLauncher", 0);
    }

    public static String getLauncherInfo() {
        return "Launcher %s | Java %d(%s %s) x%d | %s x%d".formatted(Version.getVersion().toString(), JVMHelper.JVM_VERSION, JVMHelper.RUNTIME_MXBEAN.getVmName(), System.getProperty("java.version"), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name(), JVMHelper.OS_BITS);
    }

    public static String getMiniLauncherInfo() {
        return "Launcher %s | Java %d(%s) x%d | %s x%d".formatted(Version.getVersion().toString(), JVMHelper.JVM_VERSION, System.getProperty("java.version"), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name(), JVMHelper.OS_BITS);
    }

    @Override
    public void init(LauncherInitContext initContext) {
        this.registerEvent(this::preGuiPhase, ClientPreGuiPhase.class);
        this.registerEvent(this::engineInitPhase, ClientEngineInitPhase.class);
        this.registerEvent(this::exitPhase, ClientExitPhase.class);
        this.registerEvent(this::consoleUnlock, ClientUnlockConsoleEvent.class);
    }

    private void preGuiPhase(ClientPreGuiPhase phase) {
        try {
            Class.forName("javafx.application.Application");
        }
        catch (ClassNotFoundException e) {
            JavaRuntimeModule.noJavaFxAlert();
            LauncherEngine.exitLauncher(0);
        }
        try {
            Method m = JavaFXApplication.class.getMethod(new String(Base64.getDecoder().decode("c3RhcnQ=")), Stage.class);
            if (m.getDeclaringClass() != JavaFXApplication.class) {
                throw new RuntimeException("Method start not override");
            }
        }
        catch (Throwable exception) {
            logger.error("", exception);
            JavaRuntimeModule.noInitMethodAlert();
            LauncherEngine.exitLauncher(0);
        }
        phase.runtimeProvider = this.provider = new StdJavaRuntimeProvider();
    }

    private void consoleUnlock(ClientUnlockConsoleEvent event) {
        RuntimeProvider runtimeProvider = JavaRuntimeModule.engine.runtimeProvider;
        if (runtimeProvider instanceof StdJavaRuntimeProvider) {
            StdJavaRuntimeProvider stdJavaRuntimeProvider = (StdJavaRuntimeProvider)runtimeProvider;
            stdJavaRuntimeProvider.registerPrivateCommands();
        }
    }

    private void engineInitPhase(ClientEngineInitPhase initPhase) {
        engine = initPhase.engine;
    }

    private void exitPhase(ClientExitPhase exitPhase) {
        boolean isAlreadyShutdown = SHUTDOWN_STARTED.getAndSet(true);
        if (!isAlreadyShutdown && LauncherBackendAPIHolder.getApi() != null) {
            LauncherBackendAPIHolder.getApi().shutdown();
        }
    }

    static {
        SHUTDOWN_STARTED = new AtomicBoolean(false);
    }
}

