/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.components;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class BasicUserControls
extends FxComponent {
    public BasicUserControls(Pane layout, JavaFXApplication application) {
        super(layout, application);
    }

    @Override
    public String getName() {
        return "userControls";
    }

    @Override
    protected void doInit() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#controls", "#exit").ifPresent(b -> b.setOnAction(e -> this.onExit()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#controls", "#minimize").ifPresent(b -> b.setOnAction(e -> this.onMinimize()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#controls", "#deauth").ifPresent(b -> b.setOnAction(e -> this.onDeauth()));
    }

    protected void onExit() {
        this.currentStage.close();
    }

    protected void onMinimize() {
        this.currentStage.hide();
    }

    protected void onDeauth() {
        this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.exitDialog.header"), this.application.getTranslation("runtime.scenes.settings.exitDialog.description"), this::userExit, () -> {}, true);
    }

    protected void userExit() {
        this.processRequest(this.application.getTranslation("runtime.scenes.settings.exitDialog.processing"), LauncherBackendAPIHolder.getApi().userExit(), event -> ContextHelper.runInFxThreadStatic(() -> {
            this.application.gui.loginScene.clearPassword();
            this.application.gui.loginScene.reset();
            try {
                this.application.authService.exit();
                this.switchScene(this.application.gui.loginScene);
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        }), (EventHandler<ActionEvent>)((EventHandler)event -> {}));
    }

    @Override
    public void reset() {
    }
}

