/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.components;

import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.core.utils.JavaFxUtils;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class ServerButton
extends FxComponent {
    private static final Logger logger = LoggerFactory.getLogger(ServerButton.class);
    private static final String SERVER_BUTTON_FXML = "components/serverButton.fxml";
    private static final String SERVER_BUTTON_CUSTOM_FXML = "components/serverButton/%s.fxml";
    private static final String SERVER_BUTTON_DEFAULT_IMAGE = "images/servers/example.png";
    private static final String SERVER_BUTTON_CUSTOM_IMAGE = "images/servers/%s.png";
    public ProfileFeatureAPI.ClientProfile profile;
    private Button saveButton;
    private Button resetButton;
    private Region serverLogo;

    protected ServerButton(JavaFXApplication application, ProfileFeatureAPI.ClientProfile profile) {
        super(ServerButton.getServerButtonFxml(application, profile), application);
        this.profile = profile;
    }

    public static ServerButton createServerButton(JavaFXApplication application, ProfileFeatureAPI.ClientProfile profile) {
        return new ServerButton(application, profile);
    }

    private static String getServerButtonFxml(JavaFXApplication application, ProfileFeatureAPI.ClientProfile profile) {
        String customFxml = String.format(SERVER_BUTTON_CUSTOM_FXML, profile.getUUID().toString());
        URL fxml = application.tryResource(customFxml);
        if (fxml != null) {
            return customFxml;
        }
        return SERVER_BUTTON_FXML;
    }

    @Override
    public String getName() {
        return "serverButton";
    }

    @Override
    protected void doInit() {
        ((Labeled)LookupHelper.lookup((Node)this.layout, "#nameServer")).setText(this.profile.getName());
        ((Labeled)LookupHelper.lookup((Node)this.layout, "#genreServer")).setText(this.profile.getMinecraftVersion());
        this.serverLogo = (Region)LookupHelper.lookup((Node)this.layout, "#serverLogo");
        URL logo = this.application.tryResource(String.format(SERVER_BUTTON_CUSTOM_IMAGE, this.profile.getUUID().toString()));
        if (logo == null) {
            logo = this.application.tryResource(SERVER_BUTTON_DEFAULT_IMAGE);
        }
        if (logo != null) {
            this.serverLogo.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image(logo.toString()), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(0.0, 0.0, true, true, false, true))}));
            JavaFxUtils.setRadius(this.serverLogo, 20.0);
        }
        AtomicLong currentOnline = new AtomicLong(0L);
        AtomicLong maxOnline = new AtomicLong(0L);
        Runnable update = () -> this.contextHelper.runInFxThread(() -> {
            if (currentOnline.get() == 0L && maxOnline.get() == 0L) {
                ((Labeled)LookupHelper.lookup((Node)this.layout, "#online")).setText("?");
            } else {
                ((Labeled)LookupHelper.lookup((Node)this.layout, "#online")).setText(String.valueOf(currentOnline.get()));
            }
        });
        this.application.pingService.getPingReport(this.profile.getUUID()).thenAccept(report -> {
            if (report != null) {
                currentOnline.addAndGet(report.playersOnline);
                maxOnline.addAndGet(report.maxPlayers);
            }
            update.run();
        });
        this.saveButton = (Button)LookupHelper.lookup((Node)this.layout, "#save");
        this.resetButton = (Button)LookupHelper.lookup((Node)this.layout, "#reset");
    }

    @Override
    protected void doPostInit() {
    }

    public void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.layout.setOnMouseClicked(eventHandler);
    }

    public void enableSaveButton(String text, EventHandler<ActionEvent> eventHandler) {
        this.saveButton.setVisible(true);
        if (text != null) {
            this.saveButton.setText(text);
        }
        this.saveButton.setOnAction(eventHandler);
    }

    public void enableResetButton(String text, EventHandler<ActionEvent> eventHandler) {
        this.resetButton.setVisible(true);
        if (text != null) {
            this.resetButton.setText(text);
        }
        this.resetButton.setOnAction(eventHandler);
    }

    public void addTo(Pane pane) {
        if (!this.isInit()) {
            try {
                this.init();
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
        pane.getChildren().add((Object)this.layout);
    }

    public void addTo(Pane pane, int position) {
        if (!this.isInit()) {
            try {
                this.init();
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
        pane.getChildren().add(position, (Object)this.layout);
    }

    @Override
    public void reset() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }
}

