/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.components;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.core.backend.extensions.TextureUploadExtension;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.core.utils.JavaFxUtils;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class UserBlock
extends FxComponent {
    private static final Logger logger = LoggerFactory.getLogger(UserBlock.class);
    private ImageView avatar;
    private Image originalAvatarImage;

    public UserBlock(Pane layout, JavaFXApplication application) {
        super(layout, application);
    }

    @Override
    public String getName() {
        return "userBlock";
    }

    @Override
    protected void doInit() {
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(h -> {
            try {
                JavaFxUtils.setStaticRadius(h, 8.0);
                h.setImage(this.originalAvatarImage);
            }
            catch (Throwable e) {
                logger.warn("Skin head error");
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(e -> e.textProperty().bind(this.application.authService.username));
        LookupHelper.lookupIfPossible((Node)this.layout, "#role").ifPresent(e -> e.setText(this.application.authService.getMainRole()));
        this.avatar.setImage(this.originalAvatarImage);
        this.resetAvatar();
        TextureUploadExtension extension = LauncherBackendAPIHolder.getApi().getExtension(TextureUploadExtension.class);
        if (extension != null) {
            LookupHelper.lookupIfPossible((Node)this.layout, "#customization").ifPresent(h -> {
                h.setVisible(true);
                h.setOnAction(a -> this.application.gui.processingOverlay.processRequest(this.currentStage, this.application.getTranslation("runtime.overlay.processing.text.uploadassetinfo"), extension.fetchTextureUploadInfo(), info -> this.contextHelper.runInFxThread(() -> this.application.gui.uploadAssetOverlay.show(this.currentStage, (EventHandler<ActionEvent>)((EventHandler)f -> this.application.gui.uploadAssetOverlay.onAssetUploadInfo((TextureUploadFeatureAPI.TextureUploadInfo)info)))), this::errorHandle, (EventHandler<ActionEvent>)((EventHandler)e -> {})));
            });
        }
    }

    public void resetAvatar() {
        if (this.avatar == null) {
            return;
        }
        JavaFxUtils.putAvatarToImageView(this.application, this.application.authService.getUsername(), this.avatar);
    }
}

