/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.core.backend.UserSettings;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.launcher.gui.core.SkinManager;
import pro.gravit.launcher.gui.core.StdJavaRuntimeProvider;
import pro.gravit.launcher.gui.core.commands.RuntimeCommand;
import pro.gravit.launcher.gui.core.commands.VersionCommand;
import pro.gravit.launcher.gui.core.config.GuiModuleConfig;
import pro.gravit.launcher.gui.core.config.RuntimeSettings;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.core.impl.GuiObjectsContainer;
import pro.gravit.launcher.gui.core.impl.MessageManager;
import pro.gravit.launcher.gui.core.internal.FXMLFactory;
import pro.gravit.launcher.gui.core.service.AuthService;
import pro.gravit.launcher.gui.core.service.BackendCallbackService;
import pro.gravit.launcher.gui.core.service.PingService;
import pro.gravit.launcher.gui.core.service.ProfileService;
import pro.gravit.launcher.gui.stage.PrimaryStage;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.client.events.ClientGuiPhase;
import pro.gravit.launcher.runtime.managers.ConsoleManager;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.IOHelper;

public class JavaFXApplication
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(JavaFXApplication.class);
    private static final AtomicReference<JavaFXApplication> INSTANCE = new AtomicReference();
    public final LauncherConfig config = Launcher.getConfig();
    public final ExecutorService workers = Executors.newWorkStealingPool(4);
    public RuntimeSettings runtimeSettings;
    public GuiObjectsContainer gui;
    public AuthService authService;
    public ProfileService profileService;
    public GuiModuleConfig guiModuleConfig;
    public MessageManager messageManager;
    public SkinManager skinManager;
    public FXMLFactory fxmlFactory;
    public PingService pingService;
    public BackendCallbackService backendCallbackService;
    private PrimaryStage mainStage;
    private boolean debugMode;
    private ResourceBundle resources;
    private static volatile LauncherBackendAPI.ResourceLayer resourceLayer;
    private CommandCategory runtimeCategory;

    public JavaFXApplication() {
        INSTANCE.set(this);
    }

    public static JavaFXApplication getInstance() {
        return INSTANCE.get();
    }

    public FxScene getCurrentScene() {
        return (FxScene)this.mainStage.getVisualComponent();
    }

    public PrimaryStage getMainStage() {
        return this.mainStage;
    }

    public void init() throws Exception {
        UserSettings.providers.register("stdruntime", RuntimeSettings.class);
        this.backendCallbackService = new BackendCallbackService(this);
        this.backendCallbackService.initDataCallback = LauncherBackendAPIHolder.getApi().init();
        this.guiModuleConfig = new GuiModuleConfig();
        this.runtimeSettings = (RuntimeSettings)LauncherBackendAPIHolder.getApi().getUserSettings("stdruntime", a -> RuntimeSettings.getDefault(this.guiModuleConfig));
        this.runtimeSettings.apply();
        System.setProperty("prism.vsync", String.valueOf(this.runtimeSettings.globalSettings.prismVSync));
        DirBridge.dirUpdates = this.runtimeSettings.updatesDir == null ? DirBridge.defaultUpdatesDir : this.runtimeSettings.updatesDir;
        this.authService = new AuthService(this);
        this.profileService = new ProfileService(this);
        this.messageManager = new MessageManager(this);
        this.skinManager = new SkinManager(this);
        this.pingService = new PingService();
        LauncherBackendAPIHolder.getApi().setCallback(this.backendCallbackService);
        this.registerCommands();
    }

    public void start(Stage stage) {
        this.debugMode = LauncherBackendAPIHolder.getApi().isTestMode();
        this.resetDirectory();
        if (this.runtimeSettings.locale == null) {
            this.runtimeSettings.locale = RuntimeSettings.DEFAULT_LOCALE;
        }
        try {
            this.updateLocaleResources(this.runtimeSettings.locale.name);
        }
        catch (Throwable e) {
            JavaRuntimeModule.noLocaleAlert(this.runtimeSettings.locale.name);
            if (!(e instanceof FileNotFoundException)) {
                logger.error("", e);
            }
            Platform.exit();
        }
        try {
            this.mainStage = new PrimaryStage(this, stage, "%s Launcher".formatted(this.config.projectName));
            this.gui = new GuiObjectsContainer(this);
            this.gui.init();
            this.mainStage.setScene(this.gui.loginScene, true);
            this.gui.background.init();
            this.mainStage.pushBackground(this.gui.background);
            this.mainStage.show();
            LauncherEngine.modulesManager.invokeEvent(new ClientGuiPhase(StdJavaRuntimeProvider.getInstance()));
            AuthRequest.registerProviders();
        }
        catch (Throwable e) {
            logger.error("", e);
            JavaRuntimeModule.errorHandleAlert(e);
            Platform.exit();
        }
    }

    public void updateLocaleResources(String locale) throws IOException {
        try (InputStream input = this.getResource("runtime_%s.properties".formatted(locale));){
            this.resources = new PropertyResourceBundle(input);
        }
        this.fxmlFactory = new FXMLFactory(this.resources, this.workers);
    }

    public void resetDirectory() {
        String themeDir = this.runtimeSettings.theme == null ? RuntimeSettings.LAUNCHER_THEME.COMMON.name : this.runtimeSettings.theme.name;
        resourceLayer = LauncherBackendAPIHolder.getApi().makeResourceLayer(List.of(Path.of("themes/" + themeDir, new String[0])));
    }

    private void registerCommands() {
        this.runtimeCategory = new BaseCommandCategory();
        this.runtimeCategory.registerCommand("version", new VersionCommand());
        if (ConsoleManager.isConsoleUnlock) {
            this.registerPrivateCommands();
        }
        ConsoleManager.handler.registerCategory(new CommandHandler.Category(this.runtimeCategory, "runtime"));
    }

    public void registerPrivateCommands() {
        if (this.runtimeCategory == null) {
            return;
        }
        this.runtimeCategory.registerCommand("runtime", new RuntimeCommand(this));
    }

    public void stop() {
        logger.debug("JavaFX method stop invoked");
        LauncherEngine.modulesManager.invokeEvent(new ClientExitPhase(0));
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private InputStream getResource(String name) throws IOException {
        return IOHelper.newInput(JavaFXApplication.getResourceURL(name));
    }

    public static URL getResourceURL(String name) throws IOException {
        return resourceLayer.getURL(Path.of(name, new String[0]));
    }

    public URL tryResource(String name) {
        try {
            return JavaFXApplication.getResourceURL(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setMainScene(FxScene scene) throws Exception {
        this.mainStage.setScene(scene, true);
    }

    public Stage newStage() {
        return this.newStage(StageStyle.TRANSPARENT);
    }

    public Stage newStage(StageStyle style) {
        Stage ret = new Stage();
        ret.initStyle(style);
        ret.setResizable(false);
        return ret;
    }

    public final String getTranslation(String name) {
        return this.getTranslation(name, "'%s'".formatted(name));
    }

    public final String getTranslation(String key, String defaultValue) {
        try {
            return this.resources.getString(key);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public boolean openURL(String url) {
        try {
            this.getHostServices().showDocument(url);
            return true;
        }
        catch (Throwable e) {
            logger.error("", e);
            return false;
        }
    }
}

