/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.commands.runtime;

import java.util.ArrayList;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.JVMHelper;

public class InfoCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(InfoCommand.class);
    private final JavaFXApplication application;

    public InfoCommand(JavaFXApplication application) {
        this.application = application;
    }

    @Override
    public String getArgsDescription() {
        return "[]";
    }

    @Override
    public String getUsageDescription() {
        return "show javafx info";
    }

    @Override
    public void invoke(String ... args) {
        Platform.runLater(() -> {
            logger.info("OS {} ARCH {} Java {}", JVMHelper.OS_TYPE.name(), JVMHelper.ARCH_TYPE.name(), JVMHelper.JVM_VERSION);
            logger.info("JavaFX version: {}", (Object)System.getProperty("javafx.runtime.version"));
            ArrayList<String> supportedFeatures = new ArrayList<String>();
            ArrayList<String> unsupportedFeatures = new ArrayList<String>();
            for (ConditionalFeature e : ConditionalFeature.values()) {
                if (Platform.isSupported((ConditionalFeature)e)) {
                    supportedFeatures.add(e.name());
                    continue;
                }
                unsupportedFeatures.add(e.name());
            }
            logger.info("JavaFX supported features: [{}]", (Object)String.join((CharSequence)",", supportedFeatures));
            logger.info("JavaFX unsupported features: [{}]", (Object)String.join((CharSequence)",", unsupportedFeatures));
            logger.info("Is accessibility active {}", (Object)(Platform.isAccessibilityActive() ? "true" : "false"));
        });
    }
}

