/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.backend.UserSettings;
import pro.gravit.launcher.gui.core.config.GuiModuleConfig;
import pro.gravit.launcher.gui.core.utils.SystemTheme;
import pro.gravit.launcher.runtime.client.DirBridge;

public class RuntimeSettings
extends UserSettings {
    public static final LAUNCHER_LOCALE DEFAULT_LOCALE = LAUNCHER_LOCALE.RUSSIAN;
    public transient Path updatesDir;
    @LauncherNetworkAPI
    public String login;
    @LauncherNetworkAPI
    public AuthMethodPassword password;
    @LauncherNetworkAPI
    public boolean autoAuth;
    @LauncherNetworkAPI
    public String lastAuth;
    @LauncherNetworkAPI
    public String updatesDirPath;
    @LauncherNetworkAPI
    public UUID lastProfile;
    @LauncherNetworkAPI
    public volatile LAUNCHER_LOCALE locale;
    @LauncherNetworkAPI
    public volatile LAUNCHER_THEME theme = LAUNCHER_THEME.COMMON;
    @LauncherNetworkAPI
    public List<ClientProfile> profiles;
    @LauncherNetworkAPI
    public GlobalSettings globalSettings = GlobalSettings.makeGlobalSettings(new GuiModuleConfig());

    public static RuntimeSettings getDefault(GuiModuleConfig config) {
        RuntimeSettings runtimeSettings = new RuntimeSettings();
        runtimeSettings.autoAuth = false;
        runtimeSettings.updatesDir = DirBridge.defaultUpdatesDir;
        runtimeSettings.locale = config.locale == null ? LAUNCHER_LOCALE.RUSSIAN : LAUNCHER_LOCALE.valueOf(config.locale);
        try {
            runtimeSettings.theme = SystemTheme.getSystemTheme();
        }
        catch (Throwable e) {
            runtimeSettings.theme = LAUNCHER_THEME.COMMON;
        }
        return runtimeSettings;
    }

    public void apply() {
        if (this.updatesDirPath != null) {
            this.updatesDir = Paths.get(this.updatesDirPath, new String[0]);
        }
    }

    public static enum LAUNCHER_THEME {
        COMMON(null, "default"),
        DARK("dark", "dark");

        public final String name;
        public final String displayName;

        private LAUNCHER_THEME(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }

    public static class GlobalSettings {
        @LauncherNetworkAPI
        public boolean prismVSync = true;
        @LauncherNetworkAPI
        public boolean debugAllClients = true;

        public static GlobalSettings makeGlobalSettings(GuiModuleConfig config) {
            GlobalSettings settings = new GlobalSettings();
            settings.debugAllClients = !config.disableDebugByDefault;
            return settings;
        }
    }

    public static enum LAUNCHER_LOCALE {
        RUSSIAN("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
        BELARUSIAN("be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f"),
        UKRAINIAN("uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
        POLISH("pl", "Polska"),
        ENGLISH("en", "English");

        public final String name;
        public final String displayName;

        private LAUNCHER_LOCALE(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }
}

