/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.impl;

import java.util.concurrent.CompletableFuture;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.util.Duration;
import pro.gravit.launcher.gui.core.impl.FxComponent;

public class ContextHelper {
    private final FxComponent pane;

    ContextHelper(FxComponent pane) {
        this.pane = pane;
    }

    public static <T> CompletableFuture<T> runInFxThreadStatic(GuiExceptionCallback<T> callback) {
        CompletableFuture result = new CompletableFuture();
        if (Platform.isFxApplicationThread()) {
            try {
                result.complete(callback.call());
            }
            catch (Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        } else {
            Platform.runLater(() -> {
                try {
                    result.complete(callback.call());
                }
                catch (Throwable throwable) {
                    result.completeExceptionally(throwable);
                }
            });
        }
        return result;
    }

    public static <T> CompletableFuture<T> runAfterTimeoutStatic(Duration duration, GuiExceptionCallback<T> callback) {
        CompletableFuture result = new CompletableFuture();
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(duration, x -> Platform.runLater(() -> {
            try {
                result.complete(callback.call());
            }
            catch (Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        }), new KeyValue[0])});
        timeline.play();
        return result;
    }

    public <T> T runCallback(GuiExceptionCallback<T> callback) {
        try {
            return callback.call();
        }
        catch (Throwable throwable) {
            this.errorHandling(throwable);
            return null;
        }
    }

    public void runCallback(GuiExceptionRunnable callback) {
        try {
            callback.call();
        }
        catch (Throwable throwable) {
            this.errorHandling(throwable);
        }
    }

    public static CompletableFuture<Void> runInFxThreadStatic(GuiExceptionRunnable callback) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (Platform.isFxApplicationThread()) {
            try {
                callback.call();
                result.complete(null);
            }
            catch (Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        } else {
            Platform.runLater(() -> {
                try {
                    callback.call();
                    result.complete(null);
                }
                catch (Throwable throwable) {
                    result.completeExceptionally(throwable);
                }
            });
        }
        return result;
    }

    public final <T> CompletableFuture<T> runInFxThread(GuiExceptionCallback<T> callback) {
        return ContextHelper.runInFxThreadStatic(callback).exceptionally(t -> {
            this.errorHandling((Throwable)t);
            return null;
        });
    }

    public final <T> CompletableFuture<T> runAfterTimeout(Duration duration, GuiExceptionCallback<T> callback) {
        return ContextHelper.runAfterTimeoutStatic(duration, callback).exceptionally(t -> {
            this.errorHandling((Throwable)t);
            return null;
        });
    }

    public final CompletableFuture<Void> runInFxThread(GuiExceptionRunnable callback) {
        return ContextHelper.runInFxThreadStatic(callback).exceptionally(t -> {
            this.errorHandling((Throwable)t);
            return null;
        });
    }

    final void errorHandling(Throwable e) {
        if (this.pane != null) {
            this.pane.errorHandle(e);
        }
    }

    public static interface GuiExceptionCallback<T> {
        public T call() throws Throwable;
    }

    public static interface GuiExceptionRunnable {
        public void call() throws Throwable;
    }
}

