/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxOverlay;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.core.impl.FxStage;
import pro.gravit.launcher.gui.core.impl.UIComponent;
import pro.gravit.launcher.gui.core.impl.VisualComponentBase;
import pro.gravit.launcher.gui.core.interfaces.ValueComponent;
import pro.gravit.launcher.gui.core.internal.FXExecutorService;
import pro.gravit.launcher.gui.core.internal.FXMLFactory;

public abstract class FxComponent
extends VisualComponentBase {
    private static final Logger logger = LoggerFactory.getLogger(FxComponent.class);
    protected final JavaFXApplication application;
    protected final ContextHelper contextHelper;
    protected final FXExecutorService fxExecutor;
    protected FxStage currentStage;
    private final String sysFxmlPath;
    private Parent sysFxmlRoot;
    private CompletableFuture<Node> sysFxmlFuture;
    protected boolean isResetOnShow = false;

    protected FxComponent(String fxmlPath, JavaFXApplication application) {
        this.application = application;
        this.sysFxmlPath = fxmlPath;
        this.contextHelper = new ContextHelper(this);
        this.fxExecutor = new FXExecutorService(this.contextHelper);
        if (application.guiModuleConfig.lazy) {
            this.sysFxmlFuture = application.fxmlFactory.getAsync(this.sysFxmlPath);
        }
    }

    protected FxComponent(Pane layout, JavaFXApplication application) {
        this.application = application;
        this.sysFxmlPath = null;
        this.contextHelper = new ContextHelper(this);
        this.layout = layout;
        this.fxExecutor = new FXExecutorService(this.contextHelper);
    }

    protected <T> Void errorHandle(T value, Throwable e) {
        this.errorHandle(e);
        return null;
    }

    protected synchronized Parent getFxmlRoot() {
        try {
            if (this.sysFxmlRoot == null) {
                if (this.sysFxmlFuture == null) {
                    this.sysFxmlFuture = this.application.fxmlFactory.getAsync(this.sysFxmlPath);
                }
                this.sysFxmlRoot = (Parent)this.sysFxmlFuture.get();
            }
            return this.sysFxmlRoot;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                cause = cause.getCause();
            }
            if (cause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)cause;
                throw runtimeException;
            }
            throw new FXMLFactory.FXMLLoadException(cause);
        }
    }

    protected <T extends UIComponent> T use(Pane layout, BiFunction<Pane, JavaFXApplication, T> constructor) {
        UIComponent object = (UIComponent)constructor.apply(layout, this.application);
        try {
            if (object instanceof FxComponent) {
                FxComponent fxComponent = (FxComponent)object;
                fxComponent.currentStage = this.currentStage;
            }
            object.init();
            return (T)object;
        }
        catch (Throwable e) {
            this.errorHandle(e);
            return null;
        }
    }

    protected <T extends ValueComponent<V>, V> T use(Pane layout, BiFunction<Pane, JavaFXApplication, T> constructor, V value) {
        ValueComponent object = (ValueComponent)this.use(layout, constructor);
        if (object != null) {
            object.onValue(value);
        }
        return (T)object;
    }

    @Override
    public void init() throws Exception {
        if (this.layout == null) {
            this.layout = (Pane)this.getFxmlRoot();
        }
        this.doInit();
        this.isInit = true;
    }

    protected void switchScene(FxScene scene) throws Exception {
        this.currentStage.setScene(scene, true);
        if (this.currentStage.getVisualComponent() != null) {
            this.currentStage.getVisualComponent().onHide();
            scene.onShow();
        }
    }

    protected void switchToBackScene() throws Exception {
        this.currentStage.back();
    }

    public void errorHandle(Throwable e) {
        String message = null;
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        if (e instanceof RequestException) {
            message = e.getMessage();
        }
        message = message == null ? "%s: %s".formatted(e.getClass().getName(), e.getMessage()) : this.application.getTranslation("runtime.request.".concat(message), message);
        logger.error("", e);
        this.application.messageManager.createNotification("Error", message);
    }

    public void errorHandle(String e) {
        logger.error("", (Object)e);
        this.application.messageManager.createNotification("Error", e);
    }

    protected Parent getFxmlRootPrivate() {
        return this.getFxmlRoot();
    }

    public void showOverlay(FxOverlay overlay, EventHandler<ActionEvent> onFinished) throws Exception {
        overlay.show(this.currentStage, onFinished);
    }

    protected final <T> void processRequest(String message, CompletableFuture<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this.currentStage, message, request, onSuccess, onError);
    }

    protected final <T> void processRequest(String message, CompletableFuture<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this.currentStage, message, request, onSuccess, onException, onError);
    }
}

