/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Duration;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.core.impl.FxStage;
import pro.gravit.launcher.gui.core.utils.JavaFxUtils;

public abstract class FxOverlay
extends FxComponent {
    private final AtomicInteger useCounter = new AtomicInteger(0);
    private final AtomicReference<FadeTransition> fadeTransition = new AtomicReference();

    protected FxOverlay(String fxmlPath, JavaFXApplication application) {
        super(fxmlPath, application);
    }

    @Override
    public final void init() throws Exception {
        super.init();
    }

    public final void hide(double delay, EventHandler<ActionEvent> onFinished) {
        if (!Platform.isFxApplicationThread()) {
            throw new RuntimeException("hide() called from non FX application thread");
        }
        if (this.useCounter.decrementAndGet() != 0) {
            this.contextHelper.runInFxThread(() -> {
                if (onFinished != null) {
                    onFinished.handle(null);
                }
            });
            return;
        }
        if (!this.isInit()) {
            throw new IllegalStateException("Using method hide before init");
        }
        this.fadeTransition.set(JavaFxUtils.fade((Node)this.getFxmlRoot(), delay, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)f -> {
            if (onFinished != null) {
                onFinished.handle(f);
            }
            this.currentStage.pull((Node)this.getFxmlRoot());
            this.currentStage.enable();
            this.fadeTransition.set(null);
        })));
    }

    @Override
    protected abstract void doInit();

    @Override
    public abstract void reset();

    public void show(FxStage stage, EventHandler<ActionEvent> onFinished) throws Exception {
        if (!Platform.isFxApplicationThread()) {
            throw new RuntimeException("show() called from non FX application thread");
        }
        if (!this.isInit()) {
            this.init();
        }
        if (this.useCounter.incrementAndGet() != 1) {
            this.contextHelper.runInFxThread(() -> {
                if (onFinished != null) {
                    onFinished.handle(null);
                }
            });
            return;
        }
        if (this.fadeTransition.get() != null) {
            this.currentStage.disable();
            this.fadeTransition.get().jumpTo(Duration.ZERO);
            this.fadeTransition.get().stop();
            this.contextHelper.runInFxThread(() -> {
                if (onFinished != null) {
                    onFinished.handle(null);
                }
            });
            this.fadeTransition.set(null);
            return;
        }
        Parent root = this.getFxmlRoot();
        this.currentStage = stage;
        this.currentStage.enableMouseDrag((Node)this.layout);
        this.currentStage.push((Node)root);
        this.currentStage.disable();
        JavaFxUtils.fade((Node)root, 100.0, 0.0, 1.0, (EventHandler<ActionEvent>)((EventHandler)f -> {
            if (onFinished != null) {
                onFinished.handle(f);
            }
        }));
    }
}

