/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.gui.components.BasicUserControls;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.core.impl.FxOverlay;
import pro.gravit.launcher.gui.core.impl.FxStage;
import pro.gravit.launcher.gui.core.utils.JavaFxUtils;
import pro.gravit.launcher.gui.helper.LookupHelper;

public abstract class FxScene
extends FxComponent {
    protected final LauncherConfig launcherConfig;
    protected Pane header;
    protected BasicUserControls basicUserControls;
    protected BiFunction<Pane, JavaFXApplication, ? extends BasicUserControls> _basicUserControlConstructor = BasicUserControls::new;

    protected FxScene(String fxmlPath, JavaFXApplication application) {
        super(fxmlPath, application);
        this.launcherConfig = Launcher.getConfig();
    }

    protected FxStage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void init() throws Exception {
        this.layout = (Pane)this.getFxmlRoot();
        this.header = LookupHelper.lookupIfPossible((Node)this.layout, "#header").orElse(null);
        this.sceneBaseInit();
        super.init();
    }

    @Override
    protected abstract void doInit();

    protected void sceneBaseInit() {
        this.basicUserControls = this.use(this.header, this._basicUserControlConstructor);
        this.currentStage.enableMouseDrag((Node)this.layout);
    }

    @Override
    public void disable() {
        this.currentStage.disable();
    }

    @Override
    public void enable() {
        this.currentStage.enable();
    }

    @Override
    public abstract void reset();

    public Node getHeader() {
        return this.header;
    }

    public static void runLater(double delay, EventHandler<ActionEvent> callback) {
        JavaFxUtils.fade(null, delay, 0.0, 1.0, callback);
    }

    public class SceneAccessor {
        public void showOverlay(FxOverlay overlay, EventHandler<ActionEvent> onFinished) throws Exception {
            FxScene.this.showOverlay(overlay, onFinished);
        }

        public JavaFXApplication getApplication() {
            return FxScene.this.application;
        }

        public void errorHandle(Throwable e) {
            FxScene.this.errorHandle(e);
        }

        public void runInFxThread(ContextHelper.GuiExceptionRunnable runnable) {
            FxScene.this.contextHelper.runInFxThread(runnable);
        }

        public <T> void processRequest(String message, CompletableFuture<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
            FxScene.this.processRequest(message, request, onSuccess, onError);
        }

        public final <T> void processRequest(String message, CompletableFuture<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
            FxScene.this.processRequest(message, request, onSuccess, onException, onError);
        }
    }
}

