/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.impl;

import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.gui.dialogs.ApplyDialog;
import pro.gravit.launcher.gui.dialogs.InfoDialog;
import pro.gravit.launcher.gui.dialogs.NotificationDialog;
import pro.gravit.launcher.gui.helper.PositionHelper;
import pro.gravit.launcher.gui.stage.DialogStage;
import pro.gravit.launcher.gui.stage.PrimaryStage;

public class MessageManager {
    public final JavaFXApplication application;

    public MessageManager(JavaFXApplication application) {
        this.application = application;
    }

    public void createNotification(String head, String message) {
        this.createNotification(head, message, this.application.getCurrentScene() != null);
    }

    public void initDialogInScene(FxScene scene, AbstractDialog dialog) {
        Pane dialogRoot = (Pane)dialog.getFxmlRootPrivate();
        if (!dialog.isInit()) {
            try {
                dialog.currentStage = scene.currentStage;
                dialog.init();
            }
            catch (Exception e) {
                scene.errorHandle(e);
            }
        }
        dialog.setOnClose(() -> {
            scene.currentStage.pull((Node)dialogRoot);
            scene.currentStage.enable();
        });
        scene.disable();
        scene.currentStage.push((Node)dialogRoot);
    }

    public void createNotification(String head, String message, boolean isLauncher) {
        NotificationDialog dialog = new NotificationDialog(this.application, head, message);
        if (isLauncher) {
            PrimaryStage stage = this.application.getMainStage();
            if (stage == null) {
                throw new NullPointerException("Try show launcher notification in application.getMainStage() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> {
                dialog.init();
                stage.pushNotification((Node)dialog.getFxmlRootPrivate());
                dialog.setOnClose(() -> stage.pullNotification((Node)dialog.getFxmlRootPrivate()));
            });
        } else {
            AtomicReference<Object> stage = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                NotificationDialog.NotificationSlot slot = new NotificationDialog.NotificationSlot(scrollTo -> ((DialogStage)stage.get()).stage.setY(((DialogStage)stage.get()).stage.getY() + scrollTo), ((Pane)dialog.getFxmlRootPrivate()).getPrefHeight() + 20.0);
                dialog.setPosition(PositionHelper.PositionInfo.BOTTOM_RIGHT, slot);
                dialog.setOnClose(() -> {
                    ((DialogStage)stage.get()).close();
                    ((DialogStage)stage.get()).stage.setScene(null);
                });
                stage.set(new DialogStage(this.application, head, dialog));
                ((DialogStage)stage.get()).show();
            });
        }
    }

    public void showDialog(String header, String text, Runnable onApplyCallback, Runnable onCloseCallback, boolean isLauncher) {
        InfoDialog dialog = new InfoDialog(this.application, header, text, onApplyCallback, onCloseCallback);
        this.showAbstractDialog(dialog, header, isLauncher);
    }

    public void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, boolean isLauncher) {
        this.showApplyDialog(header, text, onApplyCallback, onDenyCallback, onDenyCallback, isLauncher);
    }

    public void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, Runnable onCloseCallback, boolean isLauncher) {
        ApplyDialog dialog = new ApplyDialog(this.application, header, text, onApplyCallback, onDenyCallback, onCloseCallback);
        this.showAbstractDialog(dialog, header, isLauncher);
    }

    public void showAbstractDialog(AbstractDialog dialog, String header, boolean isLauncher) {
        if (isLauncher) {
            FxScene scene = this.application.getCurrentScene();
            if (scene == null) {
                throw new NullPointerException("Try show launcher dialog in application.getCurrentScene() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> this.initDialogInScene(scene, dialog));
        } else {
            AtomicReference<Object> stage = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                stage.set(new DialogStage(this.application, header, dialog));
                ((DialogStage)stage.get()).show();
            });
            dialog.setOnClose(() -> {
                ((DialogStage)stage.get()).close();
                ((DialogStage)stage.get()).stage.setScene(null);
            });
        }
    }
}

