/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.service;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.core.api.method.AuthMethod;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.utils.helper.SecurityHelper;

public class AuthService {
    private final LauncherConfig config = Launcher.getConfig();
    private final JavaFXApplication application;
    public final SimpleObjectProperty<SelfUser> user = new SimpleObjectProperty();
    public final ObservableValue<String> username = this.user.map(user -> user == null ? "Player" : user.getUsername());
    private AuthMethod authAvailability;

    public AuthService(JavaFXApplication application) {
        this.application = application;
    }

    public AuthMethodPassword makePassword(String plainPassword) {
        if (this.config.passwordEncryptKey != null) {
            try {
                return new AuthAESPassword(this.encryptAESPassword(plainPassword));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AuthPlainPassword(plainPassword);
    }

    private byte[] encryptAESPassword(String password) throws Exception {
        return SecurityHelper.encrypt(Launcher.getConfig().passwordEncryptKey, password);
    }

    public void setUser(SelfUser user) {
        this.user.set((Object)user);
    }

    public void setAuthAvailability(AuthMethod info) {
        this.authAvailability = info;
    }

    public AuthMethod getAuthAvailability() {
        return this.authAvailability;
    }

    public boolean isFeatureAvailable(String name) {
        return this.authAvailability.getFeatures() != null && this.authAvailability.getFeatures().contains(name);
    }

    public String getUsername() {
        return (String)this.username.getValue();
    }

    public String getMainRole() {
        return "";
    }

    public boolean checkPermission(String name) {
        if (this.user.get() == null || ((SelfUser)this.user.get()).getPermissions() == null) {
            return false;
        }
        return ((SelfUser)this.user.get()).getPermissions().hasPerm(name);
    }

    public boolean checkDebugPermission(String name) {
        return this.application.isDebugMode() || !this.application.guiModuleConfig.disableDebugPermissions && this.checkPermission("launcher.debug." + name);
    }

    public void exit() {
        this.user.set(null);
    }
}

