/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.service;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.UIComponent;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginScene;

public class BackendCallbackService
extends LauncherBackendAPI.MainCallback {
    private static final Logger logger = LoggerFactory.getLogger(BackendCallbackService.class);
    private final JavaFXApplication application;
    public CompletableFuture<LauncherBackendAPI.LauncherInitData> initDataCallback;

    public BackendCallbackService(JavaFXApplication application) {
        this.application = application;
    }

    @Override
    public void onChangeStatus(String status) {
        super.onChangeStatus(status);
    }

    @Override
    public void onProfiles(List<ProfileFeatureAPI.ClientProfile> profiles) {
        this.application.profileService.setProfiles(profiles);
    }

    @Override
    public void onAuthorize(SelfUser selfUser) {
        ContextHelper.runInFxThreadStatic(() -> {
            this.application.authService.setUser(selfUser);
            UIComponent patt0$temp = this.application.getMainStage().getVisualComponent();
            if (patt0$temp instanceof LoginScene) {
                LoginScene loginScene = (LoginScene)patt0$temp;
                if (loginScene.getAuthFlow().isLoginStarted) {
                    return;
                }
                loginScene.onSuccessLogin(new AuthFlow.SuccessAuth(selfUser, selfUser.getUsername(), null));
            }
        });
    }

    @Override
    public void onNotify(String header, String description) {
        this.application.messageManager.createNotification(header, description);
    }

    @Override
    public void onShutdown() {
        boolean isAlreadyShutdown = JavaRuntimeModule.SHUTDOWN_STARTED.getAndSet(true);
        if (!isAlreadyShutdown) {
            Platform.exit();
            logger.info("Method after Platform.exit() called");
        }
    }
}

