/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.service;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.SecurityHelper;

public class OfflineService {
    private final JavaFXApplication application;

    public OfflineService(JavaFXApplication application) {
        this.application = application;
    }

    public boolean isAvailableOfflineMode() {
        if (this.application.guiModuleConfig.disableOfflineMode) {
            return false;
        }
        return this.application.runtimeSettings.profiles != null;
    }

    public boolean isOfflineMode() {
        return Request.getRequestService() instanceof OfflineRequestService;
    }

    public static void applyRuntimeProcessors(OfflineRequestService service) {
        service.registerRequestProcessor(AuthRequest.class, r -> {
            AuthRequest.AuthPasswordInterface patt0$temp;
            ClientPermissions permissions = new ClientPermissions();
            String login = r.login;
            if (login == null && (patt0$temp = r.password) instanceof AuthOAuthPassword) {
                AuthOAuthPassword oAuthPassword = (AuthOAuthPassword)patt0$temp;
                login = oAuthPassword.accessToken;
            }
            if (login == null) {
                login = "Player";
            }
            return new AuthRequestEvent(permissions, new PlayerProfile(UUID.nameUUIDFromBytes(login.getBytes(StandardCharsets.UTF_8)), login, new HashMap<String, Texture>(), new HashMap<String, String>()), SecurityHelper.randomStringToken(), "", null, new AuthRequestEvent.OAuthRequestEvent(login, null, 0L));
        });
        service.registerRequestProcessor(ProfilesRequest.class, r -> {
            JavaFXApplication application = JavaFXApplication.getInstance();
            List<ClientProfile> profileList = application.runtimeSettings.profiles.stream().filter(profile -> Files.exists(DirBridge.dirUpdates.resolve(profile.getDir()), new LinkOption[0]) && Files.exists(DirBridge.dirUpdates.resolve(profile.getAssetDir()), new LinkOption[0])).collect(Collectors.toList());
            return new ProfilesRequestEvent(profileList);
        });
    }
}

