/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.core.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import pro.gravit.launcher.gui.core.JavaFXApplication;

public class JavaFxUtils {
    private JavaFxUtils() {
    }

    public static boolean putAvatarToImageView(JavaFXApplication application, String username, ImageView imageView) {
        int height;
        int width = (int)imageView.getFitWidth();
        Image head = application.skinManager.getScaledFxSkinHead(username, width, height = (int)imageView.getFitHeight());
        if (head == null) {
            return false;
        }
        imageView.setImage(head);
        return true;
    }

    public static void setRadius(Region node, double radius) {
        JavaFxUtils.setRadius(node, radius, radius);
    }

    public static void setRadius(Region node, double width, double height) {
        Rectangle r = new Rectangle(30.0, 30.0);
        r.setArcWidth(width);
        r.setArcHeight(height);
        node.setClip((Node)r);
        node.widthProperty().addListener(p -> r.setWidth(node.getWidth()));
        node.heightProperty().addListener(p -> r.setHeight(node.getHeight()));
    }

    public static void setStaticRadius(ImageView node, double radius) {
        JavaFxUtils.setStaticRadius(node, radius, radius);
    }

    public static void setStaticRadius(ImageView node, double width, double height) {
        Rectangle r = new Rectangle(node.getFitWidth(), node.getFitHeight());
        r.setArcWidth(width);
        r.setArcHeight(height);
        node.setClip((Node)r);
    }

    public static URL getStyleUrl(String url) throws IOException {
        URL globalCss;
        try {
            globalCss = JavaFXApplication.getResourceURL(url + ".bss");
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            globalCss = JavaFXApplication.getResourceURL(url + ".css");
        }
        return globalCss;
    }

    public static FadeTransition fade(Node region, double delay, double from, double to, EventHandler<ActionEvent> onFinished) {
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)100.0), region);
        if (onFinished != null) {
            fadeTransition.setOnFinished(onFinished);
        }
        fadeTransition.setDelay(Duration.millis((double)delay));
        fadeTransition.setFromValue(from);
        fadeTransition.setToValue(to);
        fadeTransition.play();
        return fadeTransition;
    }
}

