/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.dialogs;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class InfoDialog
extends AbstractDialog {
    private String header;
    private String text;
    private final Runnable onAccept;
    private final Runnable onClose;
    private Label textHeader;
    private Label textDescription;

    public InfoDialog(JavaFXApplication application, String header, String text, Runnable onAccept, Runnable onClose) {
        super("dialogs/info/dialog.fxml", application);
        this.header = header;
        this.text = text;
        this.onAccept = onAccept;
        this.onClose = onClose;
    }

    public void setHeader(String header) {
        this.header = header;
        if (this.isInit()) {
            this.textDescription.setText(this.text);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.isInit()) {
            this.textHeader.setText(this.header);
        }
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    protected void doInit() {
        this.textHeader = (Label)LookupHelper.lookup((Node)this.layout, "#headingDialog");
        this.textDescription = (Label)LookupHelper.lookup((Node)this.layout, "#textDialog");
        this.textHeader.setText(this.header);
        this.textDescription.setText(this.text);
        ((Button)LookupHelper.lookup((Node)this.layout, "#close")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onClose.run();
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#apply")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onAccept.run();
        });
    }
}

