/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxOverlay;
import pro.gravit.launcher.gui.core.impl.FxStage;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class ProcessingOverlay
extends FxOverlay {
    private static final Logger logger = LoggerFactory.getLogger(ProcessingOverlay.class);
    private Labeled description;

    public ProcessingOverlay(JavaFXApplication application) {
        super("overlay/processing/processing.fxml", application);
    }

    @Override
    public String getName() {
        return "processing";
    }

    @Override
    protected void doInit() {
        this.description = (Labeled)LookupHelper.lookup((Node)this.layout, "#description");
    }

    @Override
    public void reset() {
        this.description.textProperty().unbind();
        this.description.getStyleClass().remove((Object)"error");
        this.description.setText("...");
    }

    @Override
    public void errorHandle(Throwable e) {
        super.errorHandle(e);
        this.description.textProperty().unbind();
        this.description.getStyleClass().add((Object)"error");
        this.description.setText(e.toString());
    }

    public final <T> void processRequest(FxStage stage, String message, CompletableFuture<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.processRequest(stage, message, request, onSuccess, null, onError);
    }

    public final <T> void processRequest(FxStage stage, String message, CompletableFuture<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
        try {
            ContextHelper.runInFxThreadStatic(() -> this.show(stage, (EventHandler<ActionEvent>)((EventHandler)e -> {
                this.description.setText(message);
                ((CompletableFuture)request.thenAccept(result -> {
                    logger.trace("RequestFuture complete normally");
                    onSuccess.accept(result);
                    ContextHelper.runInFxThreadStatic(() -> this.hide(0.0, null));
                })).exceptionally(error -> {
                    if (onException != null) {
                        onException.accept((Throwable)error);
                    } else {
                        ContextHelper.runInFxThreadStatic(() -> this.errorHandle(error.getCause()));
                    }
                    ContextHelper.runInFxThreadStatic(() -> this.hide(2500.0, onError));
                    return null;
                });
            })));
        }
        catch (Exception e) {
            ContextHelper.runInFxThreadStatic(() -> this.errorHandle(e));
        }
    }
}

