/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.core.backend.extensions.TextureUploadExtension;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.overlays.CenterOverlay;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class UploadAssetOverlay
extends CenterOverlay {
    private static final HttpClient client = HttpClient.newBuilder().build();
    private Button uploadSkin;
    private Button uploadCape;
    private CheckBox useSlim;
    private final AtomicBoolean requireManualSlimSkinSelection = new AtomicBoolean(true);

    public UploadAssetOverlay(JavaFXApplication application) {
        super("overlay/uploadasset/uploadasset.fxml", application);
    }

    @Override
    public String getName() {
        return "uploadasset";
    }

    @Override
    protected void doInit() {
        this.uploadSkin = (Button)LookupHelper.lookup((Node)this.layout, "#uploadskin");
        this.uploadCape = (Button)LookupHelper.lookup((Node)this.layout, "#uploadcape");
        this.useSlim = (CheckBox)LookupHelper.lookup((Node)this.layout, "#useslim");
        this.uploadSkin.setOnAction(a -> this.uploadAsset("SKIN", this.requireManualSlimSkinSelection.get() ? new AssetOptions(this.useSlim.isSelected()) : null));
        this.uploadCape.setOnAction(a -> this.uploadAsset("CAPE", null));
        LookupHelper.lookupIfPossible((Node)this.layout, "#close").ifPresent(b -> b.setOnAction(e -> this.hide(0.0, null)));
    }

    public void onAssetUploadInfo(TextureUploadFeatureAPI.TextureUploadInfo event) {
        boolean uploadSkinAvailable = event.getAvailable().contains("SKIN");
        boolean uploadCapeAvailable = event.getAvailable().contains("CAPE");
        this.uploadSkin.setVisible(uploadSkinAvailable);
        this.uploadCape.setVisible(uploadCapeAvailable);
        if (uploadSkinAvailable) {
            this.requireManualSlimSkinSelection.set(event.isRequireManualSlimSkinSelect());
            this.useSlim.setVisible(event.isRequireManualSlimSkinSelect());
        }
    }

    public void uploadAsset(String name, AssetOptions options) {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG Image", new String[]{"*.png"}));
        File file = chooser.showOpenDialog((Window)this.currentStage.getStage());
        if (file == null) {
            return;
        }
        try {
            byte[] skinBytes = IOHelper.read(file.toPath());
            TextureUploadExtension textureUploadExtension = LauncherBackendAPIHolder.getApi().getExtension(TextureUploadExtension.class);
            ((CompletableFuture)textureUploadExtension.uploadTexture(name, skinBytes, options == null ? null : new TextureUploadFeatureAPI.UploadSettings(options.modelSlim())).thenAccept(texture -> {
                URI skinUrl = URI.create(texture.getUrl());
                if ("SKIN".equals(name)) {
                    this.application.skinManager.addOrReplaceSkin(this.application.authService.getUsername(), skinUrl);
                    for (FxComponent scene : this.application.gui.getComponents()) {
                        if (!scene.isInit() || !(scene instanceof SceneSupportUserBlock)) continue;
                        SceneSupportUserBlock supportUserBlock = (SceneSupportUserBlock)((Object)scene);
                        supportUserBlock.getUserBlock().resetAvatar();
                    }
                }
                this.contextHelper.runInFxThread(() -> this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.uploadasset.success.header"), this.application.getTranslation("runtime.overlay.uploadasset.success.description")));
            })).handle((x$0, x$1) -> this.errorHandle(x$0, (Throwable)x$1));
        }
        catch (IOException e) {
            this.errorHandle(e);
        }
    }

    @Override
    public void reset() {
    }

    public static final class AssetOptions {
        @LauncherNetworkAPI
        private final boolean modelSlim;

        public AssetOptions(boolean modelSlim) {
            this.modelSlim = modelSlim;
        }

        public boolean modelSlim() {
            return this.modelSlim;
        }
    }

    public record UserTexture(@LauncherNetworkAPI String url, @LauncherNetworkAPI String digest, @LauncherNetworkAPI Map<String, String> metadata) {
        Texture toLauncherTexture() {
            return new Texture(this.url, SecurityHelper.fromHex(this.digest), this.metadata);
        }
    }

    public record UploadError(@LauncherNetworkAPI String error) {
    }
}

