/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import javafx.scene.Node;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxOverlay;
import pro.gravit.launcher.gui.core.utils.JavaFxUtils;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class WelcomeOverlay
extends FxOverlay {
    private static final Logger logger = LoggerFactory.getLogger(WelcomeOverlay.class);
    private Image originalImage;

    public WelcomeOverlay(JavaFXApplication application) {
        super("overlay/welcome/welcome.fxml", application);
    }

    @Override
    public String getName() {
        return "welcome";
    }

    @Override
    protected void doInit() {
        this.reset();
    }

    @Override
    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#playerName").ifPresent(e -> e.textProperty().bind(this.application.authService.username));
        LookupHelper.lookupIfPossible((Node)this.layout, "#playerHead").ifPresent(h -> {
            try {
                JavaFxUtils.setStaticRadius(h, 8.0);
                Image image = this.application.skinManager.getScaledFxSkinHead(this.application.authService.getUsername(), (int)h.getFitWidth(), (int)h.getFitHeight());
                if (image != null) {
                    if (this.originalImage == null) {
                        this.originalImage = h.getImage();
                    }
                    h.setImage(image);
                } else if (this.originalImage != null) {
                    h.setImage(this.originalImage);
                }
            }
            catch (Throwable e) {
                logger.warn("Skin head error");
            }
        });
    }
}

