/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.debug;

import java.io.EOFException;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.launcher.gui.components.BasicUserControls;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.debug.ProcessLogOutput;

public class DebugScene
extends FxScene {
    private volatile ProcessLogOutput processLogOutput;
    private TextArea output;

    public DebugScene(JavaFXApplication application) {
        super("scenes/debug/debug.fxml", application);
        this.isResetOnShow = true;
        this._basicUserControlConstructor = (x$0, x$1) -> new DebugBasicUserControls((Pane)x$0, (JavaFXApplication)((Object)x$1));
    }

    @Override
    protected void doInit() {
        this.output = (TextArea)LookupHelper.lookup((Node)this.layout, "#output");
        this.processLogOutput = new ProcessLogOutput(this.output, !this.application.runtimeSettings.globalSettings.debugAllClients);
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#kill").ifPresent(x -> x.setOnAction(e -> this.processLogOutput.terminate()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#version").ifPresent(v -> v.setText(JavaRuntimeModule.getMiniLauncherInfo()));
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#copy").ifPresent(x -> x.setOnAction(e -> this.processLogOutput.copyToClipboard()));
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#back")).setOnAction(e -> {
            this.processLogOutput.detach();
            this.processLogOutput = new ProcessLogOutput(this.output, !this.application.runtimeSettings.globalSettings.debugAllClients);
            try {
                this.switchToBackScene();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
    }

    @Override
    public void reset() {
        this.processLogOutput.clear();
    }

    public void run(LauncherBackendAPI.ReadyProfile readyProfile) {
        try {
            readyProfile.run(this.processLogOutput);
        }
        catch (Throwable e) {
            this.errorHandle(e);
        }
    }

    public void append(String text) {
        this.processLogOutput.append(text);
    }

    @Override
    public void errorHandle(Throwable e) {
        if (!(e instanceof EOFException)) {
            this.processLogOutput.append(e.toString());
        }
    }

    @Override
    public String getName() {
        return "debug";
    }

    private class DebugBasicUserControls
    extends BasicUserControls {
        public DebugBasicUserControls(Pane layout, JavaFXApplication application) {
            super(layout, application);
        }

        @Override
        protected void onExit() {
            if (DebugScene.this.processLogOutput == null || DebugScene.this.processLogOutput.isReadyToExit.get()) {
                super.onExit();
            } else {
                this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.debug.forceExitDialog.header"), this.application.getTranslation("runtime.scenes.debug.forceExitDialog.description"), () -> {
                    DebugScene.this.processLogOutput.terminate();
                    super.onExit();
                }, () -> {}, true);
            }
        }
    }
}

