/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.debug;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;

public class ProcessLogOutput
extends LauncherBackendAPI.RunCallback {
    static final long MAX_LENGTH = 262144L;
    static final int REMOVE_LENGTH = 16384;
    private final TextArea output;
    private final Object syncObject = new Object();
    private String appendString = "";
    private boolean isOutputRunned;
    private Runnable terminateProcessCallback;
    private boolean exitWhenStarted;
    AtomicBoolean isReadyToExit = new AtomicBoolean();
    private AtomicBoolean isRunned = new AtomicBoolean();
    private AtomicBoolean isAttached = new AtomicBoolean(true);

    public ProcessLogOutput(TextArea output, boolean exitWhenStarted) {
        this.output = output;
        this.exitWhenStarted = exitWhenStarted;
    }

    public String getText() {
        return this.output.getText();
    }

    public void clear() {
        this.output.clear();
    }

    public void copyToClipboard() {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(this.getText());
        Clipboard clipboard = Clipboard.getSystemClipboard();
        clipboard.setContent((Map)clipboardContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text) {
        boolean needRun = false;
        Object object = this.syncObject;
        synchronized (object) {
            this.appendString = (long)this.appendString.length() > 262144L ? "<logs buffer overflow>\n".concat(text) : this.appendString.concat(text);
            if (!this.isOutputRunned) {
                needRun = true;
                this.isOutputRunned = true;
            }
        }
        if (needRun) {
            ContextHelper.runInFxThreadStatic(() -> {
                Object object = this.syncObject;
                synchronized (object) {
                    if ((long)this.output.lengthProperty().get() > 262144L) {
                        this.output.deleteText(0, 16384);
                    }
                    this.output.appendText(this.appendString);
                    this.appendString = "";
                    this.isOutputRunned = false;
                }
            });
        }
    }

    @Override
    public void onStarted() {
        super.onStarted();
        this.isRunned.set(true);
    }

    @Override
    public void onCanTerminate(Runnable terminate) {
        super.onCanTerminate(terminate);
        this.terminateProcessCallback = terminate;
    }

    @Override
    public void onFinished(int code) {
        super.onFinished(code);
        this.isRunned.set(false);
        if (!this.isAttached.get()) {
            return;
        }
        this.append(String.format("Process finished with exit code %s", code));
    }

    @Override
    public void onNormalOutput(byte[] buf, int offset, int size) {
        super.onNormalOutput(buf, offset, size);
        if (!this.isAttached.get()) {
            return;
        }
        this.append(new String(buf, offset, size));
    }

    @Override
    public void onErrorOutput(byte[] buf, int offset, int size) {
        super.onErrorOutput(buf, offset, size);
        if (!this.isAttached.get()) {
            return;
        }
        this.append(new String(buf, offset, size));
    }

    public void terminate() {
        if (this.terminateProcessCallback == null) {
            return;
        }
        this.terminateProcessCallback.run();
    }

    public void detach() {
        this.isAttached.set(false);
    }

    @Override
    public void onReadyToExit() {
        this.isReadyToExit.set(true);
        if (this.exitWhenStarted) {
            JavaFXApplication.getInstance().getMainStage().close();
        }
    }
}

