/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.core.api.method.AuthMethod;
import pro.gravit.launcher.core.api.method.AuthMethodDetails;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.method.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.core.api.method.details.AuthPasswordDetails;
import pro.gravit.launcher.core.api.method.details.AuthTotpDetails;
import pro.gravit.launcher.core.api.method.details.AuthWebDetails;
import pro.gravit.launcher.core.api.method.password.AuthChainPassword;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.scenes.login.AuthButton;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.LoginAndPasswordAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.LoginOnlyAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.TotpAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.WebAuthMethod;

public class AuthFlow {
    private static final Logger logger = LoggerFactory.getLogger(AuthFlow.class);
    public Map<Class<? extends AuthMethodDetails>, AbstractAuthMethod<? extends AuthMethodDetails>> authMethods = new HashMap<Class<? extends AuthMethodDetails>, AbstractAuthMethod<? extends AuthMethodDetails>>(8);
    private final LoginScene.LoginSceneAccessor accessor;
    private final List<Integer> authFlow = new ArrayList<Integer>();
    private AuthMethod authAvailability;
    private volatile AbstractAuthMethod<AuthMethodDetails> authMethodOnShow;
    private final Consumer<SuccessAuth> onSuccessAuth;
    public boolean isLoginStarted;

    public AuthFlow(LoginScene.LoginSceneAccessor accessor, Consumer<SuccessAuth> onSuccessAuth) {
        this.accessor = accessor;
        this.onSuccessAuth = onSuccessAuth;
        this.authMethods.put(AuthPasswordDetails.class, new LoginAndPasswordAuthMethod(accessor));
        this.authMethods.put(AuthWebDetails.class, new WebAuthMethod(accessor));
        this.authMethods.put(AuthTotpDetails.class, new TotpAuthMethod(accessor));
        this.authMethods.put(AuthLoginOnlyDetails.class, new LoginOnlyAuthMethod(accessor));
    }

    public void init(AuthMethod authAvailability) {
        this.authAvailability = authAvailability;
        this.reset();
    }

    public void reset() {
        this.authFlow.clear();
        this.authFlow.add(0);
        if (this.authMethodOnShow != null) {
            this.authMethodOnShow.onUserCancel();
        }
        if (!this.accessor.isEmptyContent()) {
            this.accessor.clearContent();
            this.accessor.setState(AuthButton.AuthButtonState.ACTIVE);
        }
        if (this.authMethodOnShow != null && !this.authMethodOnShow.isOverlay()) {
            this.loginWithGui();
        }
        this.authMethodOnShow = null;
        for (AbstractAuthMethod<? extends AuthMethodDetails> e : this.authMethods.values()) {
            e.reset();
        }
    }

    private CompletableFuture<LoginAndPasswordResult> tryLogin(String resentLogin, AuthMethodPassword resentPassword) {
        CompletionStage<LoginAndPasswordResult> authFuture = null;
        if (resentPassword != null) {
            authFuture = new CompletableFuture<LoginAndPasswordResult>();
            ((CompletableFuture)authFuture).complete(new LoginAndPasswordResult(resentLogin, resentPassword));
        }
        for (int i : this.authFlow) {
            AuthMethodDetails details = this.authAvailability.getDetails().get(i);
            AbstractAuthMethod<AuthMethodDetails> authMethod = this.detailsToMethod(details);
            if (authFuture == null) {
                authFuture = ((CompletableFuture)((CompletableFuture)authMethod.show(details).thenCompose(x -> {
                    this.authMethodOnShow = authMethod;
                    return CompletableFuture.completedFuture(x);
                })).thenCompose(e -> authMethod.auth(details))).thenCompose(x -> {
                    this.authMethodOnShow = null;
                    return CompletableFuture.completedFuture(x);
                });
            } else {
                authFuture = ((CompletableFuture)authFuture).thenCompose(e -> authMethod.show(details).thenApply(x -> e));
                authFuture = ((CompletableFuture)authFuture).thenCompose(x -> {
                    this.authMethodOnShow = authMethod;
                    return CompletableFuture.completedFuture(x);
                });
                authFuture = ((CompletableFuture)authFuture).thenCompose(first -> authMethod.auth(details).thenApply(second -> {
                    AuthMethodPassword password;
                    AuthMethodPassword patt0$temp;
                    String login = null;
                    if (first.login != null) {
                        login = first.login;
                    }
                    if (second.login != null) {
                        login = second.login;
                    }
                    if ((patt0$temp = first.password) instanceof AuthChainPassword) {
                        AuthChainPassword authMultiPassword = (AuthChainPassword)patt0$temp;
                        password = first.password;
                        authMultiPassword.list().add(second.password);
                    } else {
                        password = new AuthChainPassword(List.of(first.password, second.password));
                    }
                    return new LoginAndPasswordResult(login, password);
                }));
                authFuture = ((CompletableFuture)authFuture).thenCompose(x -> {
                    this.authMethodOnShow = null;
                    return CompletableFuture.completedFuture(x);
                });
            }
            authFuture = ((CompletableFuture)authFuture).thenCompose(e -> authMethod.hide().thenApply(x -> e));
        }
        return authFuture;
    }

    public AbstractAuthMethod<AuthMethodDetails> getAuthMethodOnShow() {
        return this.authMethodOnShow;
    }

    private void start(CompletableFuture<SuccessAuth> result, String resentLogin, AuthMethodPassword resentPassword) {
        CompletableFuture<LoginAndPasswordResult> authFuture = this.tryLogin(resentLogin, resentPassword);
        ((CompletableFuture)authFuture.thenAccept(e -> this.login(e.login, e.password, this.authAvailability, result))).exceptionally(e -> {
            e = e.getCause();
            this.reset();
            this.isLoginStarted = false;
            if (e instanceof AbstractAuthMethod.UserAuthCanceledException) {
                return null;
            }
            this.accessor.errorHandle((Throwable)e);
            return null;
        });
    }

    private CompletableFuture<SuccessAuth> start() {
        CompletableFuture<SuccessAuth> result = new CompletableFuture<SuccessAuth>();
        this.start(result, null, null);
        return result;
    }

    private void login(String login, AuthMethodPassword password, AuthMethod authId, CompletableFuture<SuccessAuth> result) {
        this.isLoginStarted = true;
        JavaFXApplication application = this.accessor.getApplication();
        logger.info("Auth with {} password ***** authId {}", (Object)login, (Object)authId);
        this.accessor.processing(LauncherBackendAPIHolder.getApi().authorize(login, password), application.getTranslation("runtime.overlay.processing.text.auth"), event -> result.complete(new SuccessAuth((SelfUser)event, login, password)), error -> {
            if (error.equals("auth.invalidtoken")) {
                result.completeExceptionally(new RequestException((String)error));
            } else if (error.equals("auth.require2fa")) {
                this.authFlow.clear();
                this.authFlow.add(1);
                this.accessor.runInFxThread(() -> this.start(result, login, password));
            } else if (error.startsWith("auth.require.factor.")) {
                ArrayList<Integer> newAuthFlow = new ArrayList<Integer>();
                for (String s : error.substring("auth.require.factor.".length() + 1).split("\\.")) {
                    newAuthFlow.add(Integer.parseInt(s));
                }
                this.authFlow.clear();
                this.authFlow.addAll(newAuthFlow);
                this.accessor.runInFxThread(() -> this.start(result, login, password));
            } else {
                this.authFlow.clear();
                this.authFlow.add(0);
                this.accessor.errorHandle(new RequestException((String)error));
            }
        });
    }

    void loginWithGui() {
        this.accessor.setState(AuthButton.AuthButtonState.UNACTIVE);
        AbstractAuthMethod<AuthMethodDetails> method = this.getAuthMethodOnShow();
        if (method != null) {
            method.onAuthClicked();
            return;
        }
        if (this.tryOAuthLogin()) {
            return;
        }
        this.start().thenAccept(result -> {
            if (this.onSuccessAuth != null) {
                this.onSuccessAuth.accept((SuccessAuth)result);
            }
        });
    }

    private boolean tryOAuthLogin() {
        JavaFXApplication application = this.accessor.getApplication();
        this.accessor.processing(LauncherBackendAPIHolder.getApi().tryAuthorize(), application.getTranslation("runtime.overlay.processing.text.auth"), result -> this.accessor.runInFxThread(() -> this.onSuccessAuth.accept(new SuccessAuth((SelfUser)result, null, null))), error -> {
            if (error.equals("auth.invalidtoken")) {
                this.accessor.runInFxThread(this::loginWithGui);
            }
        });
        return false;
    }

    private AbstractAuthMethod<AuthMethodDetails> detailsToMethod(AuthMethodDetails details) {
        return this.authMethods.get(details.getClass());
    }

    public void prepare() {
        this.authMethods.forEach((k, v) -> v.prepare());
    }

    public record LoginAndPasswordResult(String login, AuthMethodPassword password) {
    }

    public record SuccessAuth(SelfUser user, String recentLogin, AuthMethodPassword recentPassword) {
    }
}

