/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.method.AuthMethod;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.api.model.Texture;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.core.impl.UIComponent;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.login.AuthButton;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;

public class LoginScene
extends FxScene {
    private static final Logger logger = LoggerFactory.getLogger(LoginScene.class);
    private List<AuthMethod> auth;
    private CheckBox savePasswordCheckBox;
    private CheckBox autoenter;
    private Pane content;
    private UIComponent contentComponent;
    private AuthButton authButton;
    private ComboBox<AuthMethod> authList;
    private AuthMethod authAvailability;
    private final AuthFlow authFlow;

    public LoginScene(JavaFXApplication application) {
        super("scenes/login/login.fxml", application);
        LoginSceneAccessor accessor = new LoginSceneAccessor();
        this.authFlow = new AuthFlow(accessor, this::onSuccessLogin);
    }

    @Override
    public void doInit() {
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.globalSettingsScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.authButton = this.use(this.layout, AuthButton::new);
        this.authButton.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.contextHelper.runCallback(this.authFlow::loginWithGui)));
        this.savePasswordCheckBox = (CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword");
        this.autoenter = (CheckBox)LookupHelper.lookup((Node)this.layout, "#autoenter");
        this.autoenter.setSelected(this.application.runtimeSettings.autoAuth);
        this.autoenter.setOnAction(event -> {
            this.application.runtimeSettings.autoAuth = this.autoenter.isSelected();
        });
        this.content = (Pane)LookupHelper.lookup((Node)this.layout, "#content");
        if (this.application.guiModuleConfig.createAccountURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#createAccount")).setOnMouseClicked(e -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
        }
        if (this.application.guiModuleConfig.forgotPassURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#forgotPass")).setOnMouseClicked(e -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
        }
        this.authList = (ComboBox)LookupHelper.lookup((Node)this.layout, "#authList");
        this.authList.setConverter((StringConverter)new AuthAvailabilityStringConverter());
        this.authList.setOnAction(e -> this.changeAuthAvailability((AuthMethod)this.authList.getSelectionModel().getSelectedItem()));
        this.authFlow.prepare();
    }

    @Override
    protected void doPostInit() {
        this.getAvailabilityAuth();
    }

    private void getAvailabilityAuth() {
        this.processing(this.application.backendCallbackService.initDataCallback, this.application.getTranslation("runtime.overlay.processing.text.launcher"), initData -> this.contextHelper.runInFxThread(() -> {
            this.auth = initData.methods();
            this.authList.setVisible(this.auth.size() != 1);
            this.authList.setManaged(this.auth.size() != 1);
            for (AuthMethod authAvailability : this.auth) {
                if (!authAvailability.isVisible()) continue;
                if (this.application.runtimeSettings.lastAuth == null) {
                    if (authAvailability.getName().equals("std") || this.authAvailability == null) {
                        this.changeAuthAvailability(authAvailability);
                    }
                } else if (authAvailability.getName().equals(this.application.runtimeSettings.lastAuth)) {
                    this.changeAuthAvailability(authAvailability);
                }
                if (!authAvailability.isVisible()) continue;
                this.addAuthAvailability(authAvailability);
            }
            if (this.authAvailability == null && !this.auth.isEmpty()) {
                this.changeAuthAvailability(this.auth.get(0));
            }
            this.runAutoAuth();
        }), e -> {
            this.errorHandle((String)e);
            this.contextHelper.runAfterTimeout(Duration.seconds((double)2.0), () -> {
                Platform.exit();
                return null;
            });
        });
    }

    private void runAutoAuth() {
        block3: {
            block2: {
                if (this.application.guiModuleConfig.autoAuth) break block2;
                if (!this.application.runtimeSettings.autoAuth) break block3;
            }
            this.contextHelper.runInFxThread(this.authFlow::loginWithGui);
        }
    }

    public void changeAuthAvailability(AuthMethod authAvailability) {
        boolean isChanged = this.authAvailability != authAvailability;
        LauncherBackendAPIHolder.getApi().selectAuthMethod(authAvailability);
        this.authAvailability = authAvailability;
        this.application.authService.setAuthAvailability(authAvailability);
        ((SingleSelectionModel)this.authList.selectionModelProperty().get()).select((Object)authAvailability);
        this.authFlow.init(authAvailability);
        logger.trace("Selected auth: {}", (Object)authAvailability.getName());
    }

    public void addAuthAvailability(AuthMethod authAvailability) {
        this.authList.getItems().add((Object)authAvailability);
        logger.trace("Added {}: {}", (Object)authAvailability.getName(), (Object)authAvailability.getDisplayName());
    }

    public <T> void processing(CompletableFuture<T> request, String text, Consumer<T> onSuccess, Consumer<String> onError) {
        this.processRequest(text, request, onSuccess, onError == null ? null : thr -> onError.accept(thr.getCause().getMessage()), null);
    }

    @Override
    public void errorHandle(Throwable e) {
        super.errorHandle(e);
        this.contextHelper.runInFxThread(() -> this.authButton.setState(AuthButton.AuthButtonState.ERROR));
    }

    @Override
    public void reset() {
        this.authFlow.reset();
    }

    @Override
    public String getName() {
        return "login";
    }

    public void onSuccessLogin(AuthFlow.SuccessAuth successAuth) {
        SelfUser user = successAuth.user();
        this.application.authService.setUser(user);
        boolean savePassword = this.savePasswordCheckBox.isSelected();
        if (savePassword) {
            this.application.runtimeSettings.login = successAuth.recentLogin();
            this.application.runtimeSettings.password = null;
            this.application.runtimeSettings.lastAuth = this.authAvailability.getName();
        }
        if (user != null && user.getAssets() != null) {
            try {
                Texture skin = user.getAssets().get("SKIN");
                Texture avatar = user.getAssets().get("AVATAR");
                if (skin != null || avatar != null) {
                    this.application.skinManager.addSkinWithAvatar(user.getUsername(), skin != null ? new URI(skin.getUrl()) : null, avatar != null ? new URI(avatar.getUrl()) : null);
                    this.application.skinManager.getSkin(user.getUsername());
                }
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
        this.contextHelper.runInFxThread(() -> {
            if (this.application.gui.welcomeOverlay.isInit()) {
                this.application.gui.welcomeOverlay.reset();
            }
            this.showOverlay(this.application.gui.welcomeOverlay, (EventHandler<ActionEvent>)((EventHandler)e -> this.application.gui.welcomeOverlay.hide(2000.0, (EventHandler<ActionEvent>)((EventHandler)f -> this.onGetProfiles()))));
        });
    }

    public void onGetProfiles() {
        this.processing(LauncherBackendAPIHolder.getApi().fetchProfiles(), this.application.getTranslation("runtime.overlay.processing.text.profiles"), profiles -> this.contextHelper.runInFxThread(() -> {
            FxScene patt0$temp = this.application.getCurrentScene();
            if (patt0$temp instanceof LoginScene) {
                LoginScene loginScene = (LoginScene)patt0$temp;
                loginScene.authFlow.isLoginStarted = false;
            }
            this.application.profileService.setProfiles((List<ProfileFeatureAPI.ClientProfile>)profiles);
            this.application.setMainScene(this.application.gui.serverMenuScene);
        }), null);
    }

    public void clearPassword() {
        this.application.runtimeSettings.password = null;
        this.application.runtimeSettings.login = null;
    }

    public AuthFlow getAuthFlow() {
        return this.authFlow;
    }

    public class LoginSceneAccessor
    extends FxScene.SceneAccessor {
        public void showContent(UIComponent component) throws Exception {
            component.init();
            component.postInit();
            if (LoginScene.this.contentComponent != null) {
                LoginScene.this.content.getChildren().clear();
            }
            LoginScene.this.contentComponent = component;
            LoginScene.this.content.getChildren().add((Object)component.getLayout());
        }

        public AuthButton getAuthButton() {
            return LoginScene.this.authButton;
        }

        public void setState(AuthButton.AuthButtonState state) {
            LoginScene.this.authButton.setState(state);
        }

        public boolean isEmptyContent() {
            return LoginScene.this.content.getChildren().isEmpty();
        }

        public void clearContent() {
            LoginScene.this.content.getChildren().clear();
        }

        public <T> void processing(CompletableFuture<T> request, String text, Consumer<T> onSuccess, Consumer<String> onError) {
            LoginScene.this.processing(request, text, onSuccess, onError);
        }
    }

    private static class AuthAvailabilityStringConverter
    extends StringConverter<AuthMethod> {
        private AuthAvailabilityStringConverter() {
        }

        public String toString(AuthMethod object) {
            return object == null ? "null" : object.getDisplayName();
        }

        public GetAvailabilityAuthRequestEvent.AuthAvailability fromString(String string) {
            return null;
        }
    }
}

