/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.method.details.AuthPasswordDetails;
import pro.gravit.launcher.core.api.method.password.AuthPlainPassword;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.login.AuthButton;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;

public class LoginAndPasswordAuthMethod
extends AbstractAuthMethod<AuthPasswordDetails> {
    private static final Logger logger = LoggerFactory.getLogger(LoginAndPasswordAuthMethod.class);
    private final LoginAndPasswordOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public LoginAndPasswordAuthMethod(LoginScene.LoginSceneAccessor accessor) {
        this.accessor = accessor;
        this.application = accessor.getApplication();
        this.overlay = new LoginAndPasswordOverlay(this.application);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthPasswordDetails details) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ContextHelper.runInFxThreadStatic(() -> {
                this.accessor.showContent(this.overlay);
                future.complete(null);
            }).exceptionally(th -> {
                logger.error("", (Throwable)th);
                return null;
            });
        }
        catch (Exception e) {
            this.accessor.errorHandle(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<AuthFlow.LoginAndPasswordResult> auth(AuthPasswordDetails details) {
        this.overlay.future = new CompletableFuture();
        String login = this.overlay.login.getText();
        if (this.overlay.password.getText().isEmpty() && this.overlay.password.getPromptText().equals(this.application.getTranslation("runtime.scenes.login.password.saved"))) {
            AuthMethodPassword password = this.application.runtimeSettings.password;
            return CompletableFuture.completedFuture(new AuthFlow.LoginAndPasswordResult(login, password));
        }
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
        this.overlay.future.complete(this.overlay.getResult());
    }

    @Override
    public void onUserCancel() {
        this.overlay.future.completeExceptionally(LoginAndPasswordOverlay.USER_AUTH_CANCELED_EXCEPTION);
    }

    @Override
    public CompletableFuture<Void> hide() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOverlay() {
        return false;
    }

    public class LoginAndPasswordOverlay
    extends FxComponent {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField login;
        private TextField password;
        private CompletableFuture<AuthFlow.LoginAndPasswordResult> future;

        public LoginAndPasswordOverlay(JavaFXApplication application) {
            super("scenes/login/methods/loginpassword.fxml", application);
        }

        @Override
        public String getName() {
            return "loginandpassword";
        }

        public AuthFlow.LoginAndPasswordResult getResult() {
            String rawLogin = this.login.getText();
            String rawPassword = this.password.getText();
            return new AuthFlow.LoginAndPasswordResult(rawLogin, new AuthPlainPassword(rawPassword));
        }

        @Override
        protected void doInit() {
            this.login = (TextField)LookupHelper.lookup((Node)this.layout, "#login");
            this.password = (TextField)LookupHelper.lookup((Node)this.layout, "#password");
            this.login.textProperty().addListener(l -> LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(this.login.getText().isEmpty() ? AuthButton.AuthButtonState.UNACTIVE : AuthButton.AuthButtonState.ACTIVE));
            if (this.application.runtimeSettings.login != null) {
                this.login.setText(this.application.runtimeSettings.login);
                LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(AuthButton.AuthButtonState.ACTIVE);
            } else {
                LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(AuthButton.AuthButtonState.UNACTIVE);
            }
            if (this.application.runtimeSettings.password != null) {
                this.password.getStyleClass().add((Object)"hasSaved");
                this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password.saved"));
            }
        }

        @Override
        protected void doPostInit() {
        }

        @Override
        public void reset() {
            if (this.password == null) {
                return;
            }
            this.password.getStyleClass().removeAll((Object[])new String[]{"hasSaved"});
            this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password"));
            this.password.setText("");
            this.login.setText("");
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }
    }
}

