/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import pro.gravit.launcher.base.request.auth.password.AuthTOTPPassword;
import pro.gravit.launcher.core.api.method.details.AuthTotpDetails;
import pro.gravit.launcher.core.api.method.password.AuthTotpPassword;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;
import pro.gravit.launcher.gui.core.impl.FxComponent;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;

public class TotpAuthMethod
extends AbstractAuthMethod<AuthTotpDetails> {
    private final TotpOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public TotpAuthMethod(LoginScene.LoginSceneAccessor accessor) {
        this.accessor = accessor;
        this.application = accessor.getApplication();
        this.overlay = new TotpOverlay(this.application);
        this.overlay.accessor = accessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthTotpDetails details) {
        this.overlay.maxLength = 6;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ContextHelper.runInFxThreadStatic(() -> {
                this.accessor.showContent(this.overlay);
                future.complete(null);
            });
        }
        catch (Exception e) {
            this.accessor.errorHandle(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<AuthFlow.LoginAndPasswordResult> auth(AuthTotpDetails details) {
        this.overlay.future = new CompletableFuture();
        String totp = this.overlay.getCode();
        if (totp != null && !totp.isEmpty()) {
            return CompletableFuture.completedFuture(new AuthFlow.LoginAndPasswordResult(null, new AuthTotpPassword(totp)));
        }
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
        this.overlay.complete();
    }

    @Override
    public void onUserCancel() {
        this.overlay.future.completeExceptionally(TotpOverlay.USER_AUTH_CANCELED_EXCEPTION);
    }

    @Override
    public CompletableFuture<Void> hide() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    public static class TotpOverlay
    extends FxComponent {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField totpField;
        private CompletableFuture<AuthFlow.LoginAndPasswordResult> future;
        private LoginScene.LoginSceneAccessor accessor;
        private int maxLength;

        public TotpOverlay(JavaFXApplication application) {
            super("scenes/login/methods/totp.fxml", application);
        }

        @Override
        public String getName() {
            return "totp";
        }

        @Override
        protected void doInit() {
            this.totpField = (TextField)LookupHelper.lookup((Node)this.layout, "#totp");
            this.totpField.textProperty().addListener((obj, oldValue, value) -> {
                if (value != null && value.length() == this.maxLength) {
                    this.complete();
                }
            });
            this.totpField.setOnAction(e -> {
                if (this.totpField.getText() != null && !this.totpField.getText().isEmpty()) {
                    this.complete();
                }
            });
        }

        @Override
        protected void doPostInit() {
        }

        public void complete() {
            AuthTOTPPassword totpPassword = new AuthTOTPPassword();
            totpPassword.totp = this.getCode();
            this.future.complete(new AuthFlow.LoginAndPasswordResult(null, totpPassword));
        }

        public void requestFocus() {
            this.totpField.requestFocus();
        }

        public String getCode() {
            return this.totpField.getText();
        }

        @Override
        public void reset() {
            if (this.totpField == null) {
                return;
            }
            this.totpField.setText("");
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }
    }
}

