/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.method.details.AuthWebDetails;
import pro.gravit.launcher.core.api.method.password.AuthOAuthPassword;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxOverlay;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;

public class WebAuthMethod
extends AbstractAuthMethod<AuthWebDetails> {
    private static final Logger logger = LoggerFactory.getLogger(WebAuthMethod.class);
    WebAuthOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public WebAuthMethod(LoginScene.LoginSceneAccessor accessor) {
        this.application = accessor.getApplication();
        this.accessor = accessor;
        this.overlay = this.application.gui.registerComponent(WebAuthOverlay.class);
        this.overlay.accessor = accessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthWebDetails details) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)e -> future.complete(null)));
        }
        catch (Exception e2) {
            this.accessor.errorHandle(e2);
        }
        return future;
    }

    @Override
    public CompletableFuture<AuthFlow.LoginAndPasswordResult> auth(AuthWebDetails details) {
        this.overlay.future = new CompletableFuture();
        this.overlay.follow(details.url(), details.redirectUrl(), r -> {
            logger.info("Redirect uri: {}", r);
            this.overlay.future.complete(new AuthFlow.LoginAndPasswordResult(null, new AuthOAuthPassword((String)r)));
        });
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
    }

    @Override
    public void onUserCancel() {
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.overlay.hide((EventHandler<ActionEvent>)((EventHandler)r -> future.complete(null)));
        return future;
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    public static class WebAuthOverlay
    extends FxOverlay {
        private WebView webView;
        private LoginScene.LoginSceneAccessor accessor;
        private CompletableFuture<AuthFlow.LoginAndPasswordResult> future;

        public WebAuthOverlay(JavaFXApplication application) {
            super("overlay/webauth/webauth.fxml", application);
        }

        @Override
        public String getName() {
            return "webView";
        }

        public void hide(EventHandler<ActionEvent> onFinished) {
            this.hide(10.0, onFinished);
        }

        @Override
        protected void doInit() {
            ScrollPane webViewPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#webview");
            this.webView = new WebView();
            webViewPane.setContent((Node)new VBox(new Node[]{this.webView}));
            ((Button)LookupHelper.lookup((Node)this.layout, "#exit")).setOnAction(e -> {
                if (this.future != null) {
                    this.future.completeExceptionally(new AbstractAuthMethod.UserAuthCanceledException());
                }
                this.hide(null);
            });
        }

        public void follow(String url, String redirectUrl, Consumer<String> redirectCallback) {
            logger.info("Load url {}", (Object)url);
            this.webView.getEngine().setJavaScriptEnabled(true);
            this.webView.getEngine().load(url);
            if (redirectCallback != null) {
                this.webView.getEngine().locationProperty().addListener((obs, oldLocation, newLocation) -> {
                    if (newLocation != null) {
                        logger.info("Location: {}", newLocation);
                        if (redirectUrl != null) {
                            if (newLocation.startsWith(redirectUrl)) {
                                redirectCallback.accept((String)newLocation);
                            }
                        } else {
                            redirectCallback.accept((String)newLocation);
                        }
                    }
                });
            }
        }

        public WebView getWebView() {
            return this.webView;
        }

        @Override
        public void reset() {
        }
    }
}

