/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.options;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.scenes.options.OptionsTab;

public class OptionsScene
extends FxScene
implements SceneSupportUserBlock {
    private OptionsTab optionsTab;
    private UserBlock userBlock;

    public OptionsScene(JavaFXApplication application) {
        super("scenes/options/options.fxml", application);
    }

    @Override
    protected void doInit() {
        this.userBlock = this.use(this.layout, UserBlock::new);
        this.optionsTab = new OptionsTab(this.application, (TabPane)LookupHelper.lookup((Node)this.layout, "#tabPane"));
    }

    @Override
    public void reset() {
        Pane serverButtonContainer = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        serverButtonContainer.getChildren().clear();
        ProfileFeatureAPI.ClientProfile profile = this.application.profileService.getCurrentProfile();
        LauncherBackendAPI.ClientProfileSettings profileSettings = LauncherBackendAPIHolder.getApi().makeClientProfileSettings(profile);
        ServerButton serverButton = ServerButton.createServerButton(this.application, profile);
        serverButton.addTo(serverButtonContainer);
        serverButton.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)e -> {
            try {
                LauncherBackendAPIHolder.getApi().saveClientProfileSettings(profileSettings);
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButton.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)e -> {
            this.optionsTab.clear();
            this.optionsTab.addProfileOptionals(profileSettings);
        }));
        this.optionsTab.clear();
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(x -> x.setOnAction(e -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.optionsTab.addProfileOptionals(profileSettings);
        this.userBlock.reset();
    }

    @Override
    public String getName() {
        return "options";
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }
}

