/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.options;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.gui.core.JavaFXApplication;

public class OptionsTab {
    private final TabPane tabPane;
    private final JavaFXApplication application;
    private final Map<String, Tab> tabs = new HashMap<String, Tab>();
    private final Map<ProfileFeatureAPI.OptionalMod, Consumer<Boolean>> watchers = new HashMap<ProfileFeatureAPI.OptionalMod, Consumer<Boolean>>();

    public OptionsTab(JavaFXApplication application, TabPane tabPane) {
        this.tabPane = tabPane;
        this.application = application;
    }

    void callWatcher(ProfileFeatureAPI.OptionalMod file, Boolean value) {
        for (Map.Entry<ProfileFeatureAPI.OptionalMod, Consumer<Boolean>> v : this.watchers.entrySet()) {
            if (v.getKey() != file) continue;
            v.getValue().accept(value);
            break;
        }
    }

    public void addProfileOptionals(LauncherBackendAPI.ClientProfileSettings profileSettings) {
        this.watchers.clear();
        for (ProfileFeatureAPI.OptionalMod optionalFile : profileSettings.getAllOptionals()) {
            if (!optionalFile.isVisible()) continue;
            List<String> libraries = optionalFile.getDependencies() == null ? List.of() : optionalFile.getDependencies().stream().map(ProfileFeatureAPI.OptionalMod::getName).toList();
            Consumer<Boolean> setCheckBox = this.add(optionalFile.getCategory() == null ? "GLOBAL" : optionalFile.getCategory(), optionalFile.getName(), optionalFile.getDescription(), profileSettings.getEnabledOptionals().contains(optionalFile), 0, isSelected -> {
                if (isSelected.booleanValue()) {
                    profileSettings.enableOptional(optionalFile, this::callWatcher);
                } else {
                    profileSettings.disableOptional(optionalFile, this::callWatcher);
                }
            }, libraries);
            this.watchers.put(optionalFile, setCheckBox);
        }
    }

    public VBox addTab(String name, String displayName) {
        Tab tab = new Tab();
        tab.setText(displayName);
        VBox vbox = new VBox();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)vbox);
        scrollPane.setFitToWidth(true);
        tab.setContent((Node)scrollPane);
        this.tabs.put(name, tab);
        this.tabPane.getTabs().add((Object)tab);
        return vbox;
    }

    public Consumer<Boolean> add(String tab, String name, String description, boolean value, int padding, Consumer<Boolean> onChanged, List<String> libraries) {
        VBox vBox = new VBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        VBox.setMargin((Node)vBox, (Insets)new Insets(0.0, 0.0, 0.0, (double)(30 * --padding)));
        vBox.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                checkBox.setSelected(!checkBox.isSelected());
                onChanged.accept(checkBox.isSelected());
            }
        });
        vBox.setOnTouchPressed(e -> {
            checkBox.setSelected(!checkBox.isSelected());
            onChanged.accept(checkBox.isSelected());
        });
        vBox.getStyleClass().add((Object)"optional-container");
        checkBox.setSelected(value);
        checkBox.setText(name);
        checkBox.setOnAction(e -> onChanged.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"optional-checkbox");
        label.setText(description);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"optional-label");
        if (!libraries.isEmpty()) {
            HBox hBox = new HBox();
            hBox.getStyleClass().add((Object)"optional-library-container");
            for (String l : libraries) {
                Label lib = new Label();
                lib.setText(l);
                lib.getStyleClass().add((Object)"optional-library");
                hBox.getChildren().add((Object)lib);
            }
            vBox.getChildren().add((Object)hBox);
        }
        boolean needSelect = this.tabs.isEmpty();
        VBox components = this.tabs.containsKey(tab) ? (VBox)((ScrollPane)this.tabs.get(tab).getContent()).getContent() : this.addTab(tab, this.application.getTranslation(String.format("runtime.scenes.options.tabs.%s", tab), tab));
        components.getChildren().add((Object)vBox);
        if (needSelect) {
            this.tabPane.getSelectionModel().select(0);
        }
        return arg_0 -> ((CheckBox)checkBox).setSelected(arg_0);
    }

    public void clear() {
        this.tabPane.getTabs().clear();
        this.tabs.clear();
    }
}

