/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.serverinfo;

import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;

public class ServerInfoScene
extends FxScene
implements SceneSupportUserBlock {
    private static final Logger logger = LoggerFactory.getLogger(ServerInfoScene.class);
    private ServerButton serverButton;
    private UserBlock userBlock;

    public ServerInfoScene(JavaFXApplication application) {
        super("scenes/serverinfo/serverinfo.fxml", application);
    }

    @Override
    protected void doInit() {
        this.userBlock = this.use(this.layout, UserBlock::new);
        ((Button)LookupHelper.lookup((Node)this.layout, "#back")).setOnAction(e -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#clientSettings")).setOnAction(e -> {
            try {
                if (this.application.profileService.getCurrentProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.settingsScene);
                this.application.gui.settingsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        ProfileFeatureAPI.ClientProfile profile = this.application.profileService.getCurrentProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverName").ifPresent(e -> e.setText(profile.getName()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverDescriptionPane").ifPresent(e -> {
            Label label = (Label)e.getContent();
            label.setText(profile.getDescription());
        });
        Pane serverButtonContainer = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        serverButtonContainer.getChildren().clear();
        this.serverButton = ServerButton.createServerButton(this.application, profile);
        this.serverButton.addTo(serverButtonContainer);
        this.serverButton.enableSaveButton(this.application.getTranslation("runtime.scenes.serverinfo.serverButton.game"), (EventHandler<ActionEvent>)((EventHandler)e -> this.runClient()));
        this.userBlock.reset();
    }

    private void runClient() {
        ProfileFeatureAPI.ClientProfile profile = this.application.profileService.getCurrentProfile();
        this.contextHelper.runInFxThread(() -> {
            this.switchScene(this.application.gui.updateScene);
            CompletableFuture<LauncherBackendAPI.ReadyProfile> downloadProfile = LauncherBackendAPIHolder.getApi().downloadProfile(profile, LauncherBackendAPIHolder.getApi().makeClientProfileSettings(profile), this.application.gui.updateScene.makeDownloadCallback());
            ((CompletableFuture)downloadProfile.thenAccept(readyProfile -> this.contextHelper.runInFxThread(() -> {
                this.switchScene(this.application.gui.debugScene);
                this.application.gui.debugScene.run((LauncherBackendAPI.ReadyProfile)readyProfile);
            }).handle((success, error) -> {
                if (error != null) {
                    this.errorHandle((Throwable)error);
                }
                return null;
            }))).exceptionally(e -> {
                this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)e));
                return null;
            });
        });
    }

    @Override
    public String getName() {
        return "serverinfo";
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }
}

