/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.servermenu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.utils.helper.CommonHelper;

public class ServerMenuScene
extends FxScene
implements SceneSupportUserBlock {
    private UserBlock userBlock;

    public ServerMenuScene(JavaFXApplication application) {
        super("scenes/servermenu/servermenu.fxml", application);
    }

    @Override
    public void doInit() {
        this.userBlock = this.use(this.layout, UserBlock::new);
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.globalSettingsScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        scrollPane.setOnScroll(e -> {
            double widthContent = scrollPane.getWidth();
            double offset = widthContent * 0.15 / (scrollPane.getContent().getBoundsInLocal().getWidth() - widthContent) * Math.signum(e.getDeltaY());
            scrollPane.setHvalue(scrollPane.getHvalue() - offset);
        });
        this.reset();
        this.isResetOnShow = true;
    }

    @Override
    public void reset() {
        LinkedHashMap<ProfileFeatureAPI.ClientProfile, ServerButtonCache> serverButtonCacheMap = new LinkedHashMap<ProfileFeatureAPI.ClientProfile, ServerButtonCache>();
        ArrayList<ProfileFeatureAPI.ClientProfile> profiles = new ArrayList<ProfileFeatureAPI.ClientProfile>(this.application.profileService.getProfiles());
        profiles.sort(Comparator.comparing(ProfileFeatureAPI.ClientProfile::getName));
        int position = 0;
        for (ProfileFeatureAPI.ClientProfile profile2 : profiles) {
            ServerButtonCache cache = new ServerButtonCache();
            cache.serverButton = ServerButton.createServerButton(this.application, profile2);
            cache.position = position++;
            serverButtonCacheMap.put(profile2, cache);
        }
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        HBox serverList = (HBox)scrollPane.getContent();
        serverList.setSpacing(20.0);
        serverList.getChildren().clear();
        this.application.pingService.clear();
        serverButtonCacheMap.forEach((profile, serverButtonCache) -> {
            EventHandler handle = event -> {
                if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    return;
                }
                this.changeServer((ProfileFeatureAPI.ClientProfile)profile);
                try {
                    this.switchScene(this.application.gui.serverInfoScene);
                    this.application.gui.serverInfoScene.reset();
                }
                catch (Exception e) {
                    this.errorHandle(e);
                }
            };
            serverButtonCache.serverButton.addTo((Pane)serverList, serverButtonCache.position);
            serverButtonCache.serverButton.setOnMouseClicked((EventHandler<? super MouseEvent>)handle);
        });
        for (ProfileFeatureAPI.ClientProfile profile3 : profiles) {
            LauncherBackendAPIHolder.getApi().pingServer(profile3).thenAccept(result -> this.contextHelper.runInFxThread(() -> this.application.pingService.addReport(profile3.getUUID(), (LauncherBackendAPI.ServerPingInfo)result)));
        }
        CommonHelper.newThread("ServerPinger", true, () -> {}).start();
        this.userBlock.reset();
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }

    @Override
    public String getName() {
        return "serverMenu";
    }

    private void changeServer(ProfileFeatureAPI.ClientProfile profile) {
        this.application.profileService.setCurrentProfile(profile);
        this.application.runtimeSettings.lastProfile = profile.getUUID();
    }

    static class ServerButtonCache {
        public ServerButton serverButton;
        public int position;

        ServerButtonCache() {
        }
    }
}

