/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.helper.LookupHelper;

public abstract class BaseSettingsScene
extends FxScene {
    protected Pane componentList;
    protected Pane settingsList;

    public BaseSettingsScene(String fxmlPath, JavaFXApplication application) {
        super(fxmlPath, application);
    }

    @Override
    protected void doInit() {
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)this.layout, "#settingslist")).getContent();
        this.settingsList = (Pane)LookupHelper.lookup((Node)this.componentList, "#settings-list");
    }

    @Override
    public void reset() {
        this.settingsList.getChildren().clear();
        Label settingsListHeader = new Label(this.application.getTranslation("runtime.scenes.settings.header.options"));
        settingsListHeader.getStyleClass().add((Object)"settings-header");
        this.settingsList.getChildren().add((Object)settingsListHeader);
    }

    public void add(String languageName, boolean value, Consumer<Boolean> onChanged, boolean disabled) {
        String nameKey = "runtime.scenes.settings.properties.%s.name".formatted(languageName.toLowerCase());
        String descriptionKey = disabled ? "runtime.scenes.settings.properties.%s.disabled".formatted(languageName.toLowerCase()) : "runtime.scenes.settings.properties.%s.description".formatted(languageName.toLowerCase());
        this.add(this.application.getTranslation(nameKey, languageName), this.application.getTranslation(descriptionKey, languageName), value, onChanged, disabled);
    }

    public void add(String name, String description, boolean value, Consumer<Boolean> onChanged, boolean disabled) {
        HBox hBox = new HBox();
        CheckBox checkBox = new CheckBox();
        Label header = new Label();
        Label label = new Label();
        VBox vBox = new VBox();
        hBox.getStyleClass().add((Object)"settings-container");
        checkBox.getStyleClass().add((Object)"settings-checkbox");
        header.getStyleClass().add((Object)"settings-label-header");
        label.getStyleClass().add((Object)"settings-label");
        checkBox.setSelected(value);
        if (!disabled) {
            checkBox.setOnAction(e -> onChanged.accept(checkBox.isSelected()));
        } else {
            checkBox.setDisable(true);
        }
        header.setText(name);
        label.setText(description);
        label.setWrapText(true);
        vBox.getChildren().add((Object)header);
        vBox.getChildren().add((Object)label);
        hBox.getChildren().add((Object)checkBox);
        hBox.getChildren().add((Object)vBox);
        this.settingsList.getChildren().add((Object)hBox);
    }
}

